/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.backlog;

import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.backlog.AbstractSyslogBackLogHandler;

public class Syslog4jBackLogHandler
extends AbstractSyslogBackLogHandler {
    protected SyslogIF syslog = null;
    protected int downLevel = 4;
    protected int upLevel = 4;

    public Syslog4jBackLogHandler(String protocol) {
        this.syslog = Syslog.getInstance(protocol);
    }

    public Syslog4jBackLogHandler(String protocol, boolean appendReason) {
        this.syslog = Syslog.getInstance(protocol);
        this.appendReason = appendReason;
    }

    public Syslog4jBackLogHandler(SyslogIF syslog) {
        this.syslog = syslog;
    }

    public Syslog4jBackLogHandler(SyslogIF syslog, boolean appendReason) {
        this.syslog = syslog;
        this.appendReason = appendReason;
    }

    @Override
    public void initialize() throws SyslogRuntimeException {
    }

    @Override
    public void log(SyslogIF syslog, int level, String message, String reason) throws SyslogRuntimeException {
        if (this.syslog.getProtocol().equals(syslog.getProtocol())) {
            throw new SyslogRuntimeException("Ignoring this log entry since the backLog protocol \"" + this.syslog.getProtocol() + "\" is the same as the main protocol");
        }
        String combinedMessage = this.combine(syslog, level, message, reason);
        this.syslog.log(level, combinedMessage);
    }

    @Override
    public void down(SyslogIF syslog, String reason) {
        if (!this.syslog.getProtocol().equals(syslog.getProtocol())) {
            this.syslog.log(this.downLevel, "Syslog protocol \"" + syslog.getProtocol() + "\" is down: " + reason);
        }
    }

    @Override
    public void up(SyslogIF syslog) {
        if (!this.syslog.getProtocol().equals(syslog.getProtocol())) {
            this.syslog.log(this.downLevel, "Syslog protocol \"" + syslog.getProtocol() + "\" is up");
        }
    }
}

