/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.grpc.common;

import com.google.common.base.Strings;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcClientBuilder.class);
    private static final String CLIENT_CERTIFICATE_FILE_PATH = "tls.client.cert.path";
    private static final String CLIENT_PRIVATE_KEY_FILE_PATH = "tls.client.key.path";
    private static final String TRUST_CERTIFICATE_FILE_PATH = "tls.trust.cert.path";
    private static final String TLS_SKIP_VERIFY = "tls.skip.verify";
    private static final String TLS_ENABLED = "tls.enabled";

    public static ManagedChannel getChannel(String host, int port, Map<String, String> properties) throws IOException {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port).keepAliveWithoutCalls(true);
        boolean tlsEnabled = Boolean.parseBoolean(properties.get(TLS_ENABLED));
        if (tlsEnabled) {
            return channelBuilder.negotiationType(NegotiationType.TLS).sslContext(GrpcClientBuilder.buildSslContext(properties).build()).build();
        }
        return channelBuilder.usePlaintext().build();
    }

    public static ManagedChannel getChannelWithInterceptor(String host, int port, Map<String, String> properties, ClientInterceptor clientInterceptor) throws IOException {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port).keepAliveWithoutCalls(true);
        boolean tlsEnabled = Boolean.parseBoolean(properties.get(TLS_ENABLED));
        if (tlsEnabled) {
            LOG.info("TLS Enabled for gRPC on {}:{}", (Object)host, (Object)port);
            return ((NettyChannelBuilder)channelBuilder.negotiationType(NegotiationType.TLS).intercept(new ClientInterceptor[]{clientInterceptor})).sslContext(GrpcClientBuilder.buildSslContext(properties).build()).build();
        }
        return ((NettyChannelBuilder)channelBuilder.usePlaintext().intercept(new ClientInterceptor[]{clientInterceptor})).build();
    }

    private static SslContextBuilder buildSslContext(Map<String, String> properties) throws SSLException {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        String clientCertChainFilePath = properties.get(CLIENT_CERTIFICATE_FILE_PATH);
        String clientPrivateKeyFilePath = properties.get(CLIENT_PRIVATE_KEY_FILE_PATH);
        String trustCertCollectionFilePath = properties.get(TRUST_CERTIFICATE_FILE_PATH);
        boolean tlsSkipVerify = Boolean.parseBoolean(properties.get(TLS_SKIP_VERIFY));
        if (tlsSkipVerify) {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        if (!Strings.isNullOrEmpty((String)trustCertCollectionFilePath)) {
            builder.trustManager(new File(trustCertCollectionFilePath));
        }
        if (!Strings.isNullOrEmpty((String)clientCertChainFilePath) && !Strings.isNullOrEmpty((String)clientPrivateKeyFilePath)) {
            builder.keyManager(new File(clientCertChainFilePath), new File(clientPrivateKeyFilePath));
        } else if (!Strings.isNullOrEmpty((String)clientCertChainFilePath) || !Strings.isNullOrEmpty((String)clientPrivateKeyFilePath)) {
            LOG.error("Only one of the required file paths were provided, need both client cert and client private key");
        }
        return builder;
    }
}

