/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import javax.xml.bind.ValidationException;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequisitionImport {
    private static final Logger LOG = LoggerFactory.getLogger(RequisitionImport.class);
    private Requisition m_requisition;
    private Throwable m_throwable;

    public Requisition getRequisition() {
        return this.m_requisition;
    }

    public void setRequisition(Requisition requisition) {
        this.m_requisition = requisition;
        try {
            requisition.validate();
        }
        catch (ValidationException e) {
            if (this.m_throwable == null) {
                this.m_throwable = e;
            }
            LOG.debug("Requisition {} did not validate, but we'll ignore the exception because we've previously aborted with: {}", new Object[]{requisition, this.m_throwable, e});
        }
    }

    public Throwable getError() {
        return this.m_throwable;
    }

    public void abort(Throwable t) {
        if (this.m_throwable == null) {
            this.m_throwable = t;
        } else {
            LOG.warn("Requisition {} has already been aborted, but we received another abort message.  Ignoring.", (Object)this.m_requisition, (Object)t);
        }
    }

    public boolean isAborted() {
        return this.m_throwable != null;
    }
}

