/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPInterfaceTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(IPInterfaceTableTracker.class);
    public static final SnmpObjId IP_ADDR_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.20.1");
    public static final SnmpObjId IP_ADDR_ENT_ADDR = SnmpObjId.get((SnmpObjId)IP_ADDR_TABLE_ENTRY, (String)"1");
    public static final SnmpObjId IP_ADDR_IF_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDR_TABLE_ENTRY, (String)"2");
    public static final SnmpObjId IP_ADDR_ENT_NETMASK = SnmpObjId.get((SnmpObjId)IP_ADDR_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId IP_ADDR_ENT_BCASTADDR = SnmpObjId.get((SnmpObjId)IP_ADDR_TABLE_ENTRY, (String)"4");
    private static SnmpObjId[] s_tableColumns = new SnmpObjId[]{IP_ADDR_ENT_ADDR, IP_ADDR_IF_INDEX, IP_ADDR_ENT_NETMASK, IP_ADDR_ENT_BCASTADDR};

    public IPInterfaceTableTracker() {
        super(s_tableColumns);
    }

    public IPInterfaceTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_tableColumns);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IPInterfaceRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIPInterfaceRow((IPInterfaceRow)row);
    }

    public void processIPInterfaceRow(IPInterfaceRow row) {
    }

    static class IPInterfaceRow
    extends SnmpRowResult {
        public IPInterfaceRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public Integer getIfIndex() {
            SnmpValue value = this.getValue(IP_ADDR_IF_INDEX);
            return value == null ? null : Integer.valueOf(value.toInt());
        }

        public String getIpAddress() {
            SnmpValue value = this.getValue(IP_ADDR_ENT_ADDR);
            if (value != null) {
                return InetAddressUtils.str((InetAddress)value.toInetAddress());
            }
            SnmpInstId inst = this.getInstance();
            if (inst != null) {
                String addr = InetAddressUtils.normalize((String)inst.toString());
                if (addr == null) {
                    throw new IllegalArgumentException("cannot convert " + String.valueOf(inst) + " to an InetAddress");
                }
                return addr;
            }
            return null;
        }

        private InetAddress getNetMask() {
            SnmpValue value = this.getValue(IP_ADDR_ENT_NETMASK);
            return value == null ? null : value.toInetAddress();
        }

        public OnmsIpInterface createInterfaceFromRow() {
            Integer ifIndex = this.getIfIndex();
            String ipAddr = this.getIpAddress();
            InetAddress netMask = this.getNetMask();
            LOG.debug("createInterfaceFromRow: ifIndex = {}, ipAddress = {}, netmask = {}", new Object[]{ifIndex, ipAddr, netMask});
            if (ipAddr == null) {
                return null;
            }
            InetAddress inetAddress = InetAddressUtils.addr((String)ipAddr);
            OnmsIpInterface iface = new OnmsIpInterface(inetAddress, null);
            iface.setNetMask(netMask);
            if (ifIndex != null) {
                OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(null, ifIndex);
                snmpIface.setCollectionEnabled(true);
                iface.setSnmpInterface(snmpIface);
                iface.setIfIndex(ifIndex);
            }
            return iface;
        }
    }
}

