/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.dao.impl.util;

import com.google.common.io.Resources;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.opennms.features.config.dao.api.ConfigConverter;
import org.opennms.features.config.dao.api.ConfigDefinition;
import org.opennms.features.config.dao.api.ConfigItem;
import org.opennms.features.config.dao.impl.util.ConfigSwaggerConverter;
import org.opennms.features.config.dao.impl.util.JaxbXmlConverter;
import org.opennms.features.config.dao.impl.util.XsdModelConverter;
import org.opennms.features.config.exception.SchemaConversionException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class XsdHelper {
    public static URL getSchemaPath(String xsdName) throws IOException {
        PathMatchingResourcePatternResolver resolver;
        Resource[] resources;
        URL url = Thread.currentThread().getContextClassLoader().getResource("xsds/" + xsdName);
        if (url == null && (resources = (resolver = new PathMatchingResourcePatternResolver()).getResources("classpath*:**/" + xsdName)) != null && resources.length > 0) {
            url = resources[0].getURL();
        }
        return url;
    }

    private static XsdModelConverter getXsdModelConverter(String xsdName) {
        Assert.notNull((Object)xsdName);
        try {
            String xsdStr = Resources.toString((URL)XsdHelper.getSchemaPath(xsdName), (Charset)StandardCharsets.UTF_8);
            return new XsdModelConverter(xsdStr);
        }
        catch (IOException e) {
            throw new SchemaConversionException(xsdName, (Throwable)e);
        }
    }

    public static ConfigDefinition buildConfigDefinition(String configName, String xsdName, String topLevelElement, String basePath) {
        return XsdHelper.buildConfigDefinition(configName, xsdName, topLevelElement, basePath, false);
    }

    public static ConfigDefinition buildConfigDefinition(String configName, String xsdName, String topLevelElement, String basePath, boolean allowMultiple) {
        ConfigDefinition def = new ConfigDefinition(configName, Boolean.valueOf(allowMultiple));
        XsdModelConverter xsdConverter = XsdHelper.getXsdModelConverter(xsdName);
        ConfigItem item = xsdConverter.convert(topLevelElement);
        ConfigSwaggerConverter swaggerConverter = new ConfigSwaggerConverter();
        OpenAPI api = swaggerConverter.convert(item, basePath + "/" + configName);
        def.setSchema(api);
        def.setMetaValue("topLevelElement", (Object)topLevelElement);
        def.setMetaValue("xsdFilename", (Object)xsdName);
        def.setMetaValue("elementNameToValueName", xsdConverter.getElementNameToValueNameMap());
        return def;
    }

    public static ConfigConverter getConverter(ConfigDefinition def) throws IOException {
        String xsdName = (String)def.getMetaValue("xsdFilename");
        String topLevelElement = (String)def.getMetaValue("topLevelElement");
        Map elementNameToValueNameMap = (Map)def.getMetaValue("elementNameToValueName");
        if (xsdName == null || topLevelElement == null) {
            throw new SchemaConversionException("ConfigDefinition " + def.getConfigName() + " NOT support XmlConverter.");
        }
        return new JaxbXmlConverter(xsdName, topLevelElement, elementNameToValueNameMap);
    }
}

