/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.dao.impl.util;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.features.config.dao.api.ConfigItem;
import org.opennms.features.config.dao.impl.util.ConfigSwaggerConverter;
import org.opennms.features.config.exception.SchemaConversionException;

public class OpenAPIBuilder {
    public static final String SCHEMA_REF_TAG = "#/components/schemas/";
    private ConfigItem rootConfig;
    private String configName;
    private String topElementName;
    private String prefix;
    Set<String> usedAttributeNames = new HashSet<String>();

    public static OpenAPIBuilder createBuilder(String name, String topElementName, String prefix) {
        OpenAPIBuilder builder = new OpenAPIBuilder();
        builder.configName = name;
        builder.topElementName = topElementName;
        builder.prefix = prefix;
        builder.rootConfig = new ConfigItem();
        builder.rootConfig.setName(topElementName);
        builder.rootConfig.setType(ConfigItem.Type.OBJECT);
        return builder;
    }

    public static OpenAPIBuilder createBuilder(String name, String topElementName, String prefix, OpenAPI openapi) {
        OpenAPIBuilder builder = OpenAPIBuilder.createBuilder(name, topElementName, prefix);
        if (openapi == null) {
            return builder;
        }
        Schema schema = (Schema)openapi.getComponents().getSchemas().get(topElementName);
        if (schema == null) {
            return builder;
        }
        schema.getProperties().forEach((k, s) -> builder.walkSchema((String)k, (Schema<?>)s, builder.rootConfig, schema.getRequired(), openapi));
        return builder;
    }

    public ConfigItem getRootConfig() {
        return this.rootConfig;
    }

    private void handle$ref(Schema<?> schema, OpenAPI openapi, ConfigItem item) {
        String refObjName = schema.get$ref().replaceFirst("^#/components/schemas/", "");
        Schema refObjSchema = (Schema)openapi.getComponents().getSchemas().get(refObjName);
        if (refObjSchema.getDescription() != null) {
            item.setDocumentation(refObjSchema.getDescription());
        }
        if (refObjSchema != null && refObjSchema.getProperties() != null) {
            refObjSchema.getProperties().forEach((k, s) -> this.walkSchema((String)k, (Schema<?>)s, item, refObjSchema.getRequired(), openapi));
        }
    }

    private void walkSchema(String name, Schema<?> schema, ConfigItem currentItem, List<String> required, OpenAPI openapi) {
        ConfigItem item = this.getConfigItem(name, schema, required);
        if (item.getType() == ConfigItem.Type.ARRAY) {
            Schema childSchema = ((ArraySchema)schema).getItems();
            ConfigItem childrenItem = this.getConfigItem(name, childSchema, required);
            if (childrenItem.getType() == ConfigItem.Type.OBJECT && childSchema.get$ref() != null && childSchema.get$ref().startsWith(SCHEMA_REF_TAG)) {
                this.handle$ref(childSchema, openapi, childrenItem);
            }
            item.getChildren().add(childrenItem);
        }
        if (schema.get$ref() != null && schema.get$ref().startsWith(SCHEMA_REF_TAG)) {
            this.handle$ref(schema, openapi, item);
        }
        currentItem.getChildren().add(item);
    }

    private ConfigItem getConfigItem(String schemaKey, Schema<?> schema, List<String> required) {
        ConfigItem item = new ConfigItem();
        item.setName(schema.getName() != null ? schema.getName() : schemaKey);
        if (required != null && required.contains(item.getName())) {
            item.setRequired(true);
        }
        this.usedAttributeNames.add(schema.getName());
        item.setDefaultValue(schema.getDefault());
        if (schema instanceof DateTimeSchema) {
            item.setType(ConfigItem.Type.DATE_TIME);
        } else if (schema instanceof StringSchema) {
            item.setType(ConfigItem.Type.STRING);
            if (schema.getMinLength() != null) {
                item.setMin(Long.valueOf(schema.getMinLength().longValue()));
            }
            if (schema.getMaxLength() != null) {
                item.setMax(Long.valueOf(schema.getMaxLength().longValue()));
            }
        } else if (schema instanceof ArraySchema) {
            item.setType(ConfigItem.Type.ARRAY);
            if (schema.getMinItems() != null) {
                item.setMin(Long.valueOf(schema.getMinItems().intValue()));
            }
            if (schema.getMaxItems() != null) {
                item.setMax(Long.valueOf(schema.getMaxItems().intValue()));
            }
        } else if (schema instanceof ObjectSchema) {
            item.setType(ConfigItem.Type.OBJECT);
        } else if (schema instanceof NumberSchema || schema instanceof IntegerSchema) {
            if ("int64".equals(schema.getFormat())) {
                item.setType(ConfigItem.Type.LONG);
            } else if (schema instanceof IntegerSchema) {
                item.setType(ConfigItem.Type.INTEGER);
            } else {
                item.setType(ConfigItem.Type.NUMBER);
            }
            if (schema.getMinimum() != null) {
                item.setMin(Long.valueOf(schema.getMinimum().longValue()));
            }
            if (schema.getMaximum() != null) {
                item.setMax(Long.valueOf(schema.getMaximum().longValue()));
            }
            if (schema.getMultipleOf() != null) {
                item.setMultipleOf(Long.valueOf(schema.getMultipleOf().longValue()));
            }
        } else if (schema instanceof BooleanSchema) {
            item.setType(ConfigItem.Type.BOOLEAN);
        } else if (schema instanceof DateSchema) {
            item.setType(ConfigItem.Type.DATE);
        } else if (schema instanceof Schema) {
            item.setType(ConfigItem.Type.OBJECT);
        }
        if (schema.getPattern() != null) {
            item.setPattern(schema.getPattern());
        }
        if (schema.getDescription() != null) {
            item.setDocumentation(schema.getDescription());
        }
        return item;
    }

    public static OpenAPIBuilder createBuilder() {
        return OpenAPIBuilder.createBuilder(null, null, null);
    }

    public OpenAPI build(boolean isSingleConfig) {
        ConfigSwaggerConverter converter = new ConfigSwaggerConverter();
        return converter.convert(this.rootConfig, this.prefix + "/" + this.configName, isSingleConfig);
    }

    public OpenAPIBuilder removeAttribute(String attributeName) {
        this.rootConfig.getChildren().removeIf(item -> attributeName.equals(item.getName()));
        return this;
    }

    public OpenAPIBuilder addAttribute(ConfigItem configItem) {
        this.rootConfig.getChildren().add(configItem);
        return this;
    }

    public OpenAPIBuilder addArray(String name, ConfigItem.Type elementType, Long arrayMin, Long arrayMax, Long min, Long max, Long multipleOf, String pattern, Object defaultValue, boolean required, String doc) {
        ConfigItem arrayItem = this.getConfigItem(name, ConfigItem.Type.ARRAY, arrayMin, arrayMax, null, null, null, required, doc);
        ConfigItem children = this.getConfigItem(null, elementType, min, max, multipleOf, pattern, defaultValue, required, doc);
        arrayItem.getChildren().add(children);
        this.rootConfig.getChildren().add(arrayItem);
        return this;
    }

    public OpenAPIBuilder addArray(String name, OpenAPIBuilder childrenBuilder, Long arrayMin, Long arrayMax, boolean required, String doc) {
        ConfigItem arrayItem = this.getConfigItem(name, ConfigItem.Type.ARRAY, arrayMin, arrayMax, null, null, null, required, doc);
        childrenBuilder.rootConfig.setName(name);
        arrayItem.getChildren().add(childrenBuilder.rootConfig);
        this.rootConfig.getChildren().add(arrayItem);
        return this;
    }

    public OpenAPIBuilder addObject(String name, OpenAPIBuilder childrenBuilder, boolean required, String doc) {
        ConfigItem objectItem = this.getConfigItem(name, ConfigItem.Type.OBJECT, null, null, null, null, null, required, doc);
        objectItem.getChildren().addAll(childrenBuilder.rootConfig.getChildren());
        this.rootConfig.getChildren().add(objectItem);
        return this;
    }

    public OpenAPIBuilder addBooleanAttribute(String name, Object defaultValue, boolean required, String doc) {
        return this.addAttribute(name, ConfigItem.Type.BOOLEAN, null, null, null, null, defaultValue, required, doc);
    }

    public OpenAPIBuilder addDateTimeAttribute(String name, Object defaultValue, boolean required, String doc) {
        return this.addAttribute(name, ConfigItem.Type.DATE_TIME, null, null, null, null, defaultValue, required, doc);
    }

    public OpenAPIBuilder addDateAttribute(String name, Object defaultValue, boolean required, String doc) {
        return this.addAttribute(name, ConfigItem.Type.DATE, null, null, null, null, defaultValue, required, doc);
    }

    public OpenAPIBuilder addStringAttribute(String name, Long minLength, Long maxLength, String pattern, Object defaultValue, boolean required, String doc) {
        return this.addAttribute(name, ConfigItem.Type.STRING, minLength, maxLength, null, pattern, defaultValue, required, doc);
    }

    public OpenAPIBuilder addNumberAttribute(String name, ConfigItem.Type type, Long min, Long max, Long multipleOf, Object defaultValue, boolean required, String doc) {
        if (type != ConfigItem.Type.NUMBER && type != ConfigItem.Type.INTEGER && type != ConfigItem.Type.LONG) {
            throw new SchemaConversionException("Type should be NUMBER/INTEGER/LONG");
        }
        return this.addAttribute(name, type, min, max, multipleOf, null, defaultValue, required, doc);
    }

    private OpenAPIBuilder addAttribute(String name, ConfigItem.Type type, Long min, Long max, Long multipleOf, String pattern, Object defaultValue, boolean required, String doc) {
        return this.addAttribute(this.getConfigItem(name, type, min, max, multipleOf, pattern, defaultValue, required, doc));
    }

    private ConfigItem getConfigItem(String name, ConfigItem.Type type, Long min, Long max, Long multipleOf, String pattern, Object defaultValue, boolean required, String doc) {
        if (this.usedAttributeNames.contains(name)) {
            throw new SchemaConversionException("Duplicated attribute name exist! name = " + name);
        }
        this.usedAttributeNames.add(name);
        ConfigItem configItem = new ConfigItem();
        configItem.setType(type);
        configItem.setName(name);
        if (max != null) {
            configItem.setMax(max);
        }
        if (min != null) {
            configItem.setMin(min);
        }
        if (multipleOf != null) {
            configItem.setMultipleOf(multipleOf);
        }
        if (pattern != null) {
            configItem.setPattern(pattern);
        }
        if (defaultValue != null) {
            configItem.setDefaultValue(defaultValue);
        }
        configItem.setRequired(required);
        if (doc != null) {
            configItem.setDocumentation(doc);
        }
        return configItem;
    }
}

