/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.OpenPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.InformationElement;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerHeader;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.TLV;

public class PeerUpPacket
implements Packet {
    public final Header header;
    public final PeerHeader peerHeader;
    public final InetAddress localAddress;
    public final int localPort;
    public final int remotePort;
    public final Optional<OpenPacket> sendOpenMessage;
    public final Optional<OpenPacket> recvOpenMessage;
    public final TLV.List<InformationElement, InformationElement.Type, String> information;

    public PeerUpPacket(Header header, ByteBuf buffer, PeerAccessor peerAccessor) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        this.peerHeader = new PeerHeader(buffer);
        this.localAddress = this.peerHeader.flags.parsePaddedAddress(buffer);
        this.localPort = BufferUtils.uint16((ByteBuf)buffer);
        this.remotePort = BufferUtils.uint16((ByteBuf)buffer);
        this.sendOpenMessage = OpenPacket.parse(buffer, this.peerHeader.flags, peerAccessor.getPeerInfo(this.peerHeader));
        this.recvOpenMessage = OpenPacket.parse(buffer, this.peerHeader.flags, peerAccessor.getPeerInfo(this.peerHeader));
        this.information = TLV.List.wrap(BufferUtils.repeatRemaining((ByteBuf)buffer, b -> new InformationElement(b, peerAccessor.getPeerInfo(this.peerHeader))));
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <R> R map(Packet.Mapper<R> mapper) {
        return mapper.map(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("peerHeader", (Object)this.peerHeader).add("localAddress", (Object)this.localAddress).add("localPort", this.localPort).add("remotePort", this.remotePort).add("sendOpenMessage", this.sendOpenMessage).add("recvOpenMessage", this.recvOpenMessage).add("information", this.information).toString();
    }
}

