/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.info;

import java.util.Objects;
import org.opennms.netmgt.model.OnmsSeverity;

public enum Severity {
    Unknown,
    Normal,
    Warning,
    Minor,
    Major,
    Critical;


    public static Severity createFrom(OnmsSeverity severity) {
        Objects.requireNonNull(severity);
        switch (severity) {
            case INDETERMINATE: {
                return Unknown;
            }
            case NORMAL: {
                return Normal;
            }
            case WARNING: {
                return Warning;
            }
            case MINOR: {
                return Minor;
            }
            case MAJOR: {
                return Major;
            }
            case CRITICAL: {
                return Critical;
            }
        }
        throw new IllegalStateException("Cannot convert OnmsSeverity to Severity due to unknown severity '" + severity.name() + "'");
    }

    public boolean isLessThan(Severity other) {
        Objects.requireNonNull(other);
        return this.ordinal() < other.ordinal();
    }

    public boolean isEqual(Severity other) {
        Objects.requireNonNull(other);
        return this.ordinal() == other.ordinal();
    }
}

