/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.info;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.api.info.IpInfo;

public class NodeInfo {
    private final String location;
    private final Integer id;
    private final String foreignSource;
    private final String foreignId;
    private final String label;
    private final Set<String> categories;
    private final List<IpInfo> ipInfos;

    public NodeInfo(String location, Integer id, String foreignSource, String foreignId, String label, Set<String> categories, List<IpInfo> ipInfos) {
        this.location = location;
        this.id = id;
        this.foreignSource = foreignSource;
        this.foreignId = foreignId;
        this.label = label;
        this.categories = ImmutableSet.copyOf(categories);
        this.ipInfos = ImmutableList.copyOf(ipInfos);
    }

    public String getLocation() {
        return this.location;
    }

    public Integer getId() {
        return this.id;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public String getLabel() {
        return this.label;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public List<IpInfo> getIpInterfaces() {
        return this.ipInfos;
    }

    public NodeRef getNodeRef() {
        if (this.foreignId != null && this.foreignSource != null) {
            return NodeRef.from(this.id, this.foreignSource, this.foreignId);
        }
        return NodeRef.from(this.id);
    }

    public static NodeInfoBuilder builder() {
        return new NodeInfoBuilder();
    }

    public static class NodeInfoBuilder {
        private String location;
        private Integer id;
        private String foreignSource;
        private String foreignId;
        private String label;
        private final Set<String> categories = new HashSet<String>();
        private final List<IpInfo> ipInfos = new ArrayList<IpInfo>();

        public NodeInfoBuilder location(String location) {
            this.location = location;
            return this;
        }

        public NodeInfoBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public NodeInfoBuilder foreignSource(String foreignSource) {
            this.foreignSource = foreignSource;
            return this;
        }

        public NodeInfoBuilder foreignId(String foreignId) {
            this.foreignId = foreignId;
            return this;
        }

        public NodeInfoBuilder label(String label) {
            this.label = label;
            return this;
        }

        public NodeInfoBuilder categories(Set<String> categories) {
            this.categories.addAll(categories);
            return this;
        }

        public NodeInfoBuilder ipInterfaces(List<IpInfo> ipInfos) {
            this.ipInfos.addAll(ipInfos);
            return this;
        }

        public NodeInfo build() {
            return new NodeInfo(this.location, this.id, this.foreignSource, this.foreignId, this.label, this.categories, this.ipInfos);
        }
    }
}

