/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.Objects;

public final class VertexRef {
    private final String namespace;
    private final String id;

    public VertexRef(String namespace, String id) {
        this.namespace = VertexRef.requireNotEmpty(namespace, "namespace");
        this.id = VertexRef.requireNotEmpty(id, "id");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertexRef vertexRef = (VertexRef)o;
        return Objects.equals(this.namespace, vertexRef.namespace) && Objects.equals(this.id, vertexRef.id);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.namespace).add("id", (Object)this.id).toString();
    }

    private static String requireNotEmpty(String stringToAssert, String attributeName) {
        if (Strings.isNullOrEmpty((String)stringToAssert)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty", attributeName));
        }
        return stringToAssert;
    }
}

