/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wsmanAsset.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.wsmanAsset.adapter.WqlObj;

@XmlRootElement(name="assetField")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="snmp-asset-adapter-configuration.xsd")
public class AssetField
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="formatString", required=true)
    private String m_formatString;
    @XmlElementWrapper(name="wqlQueries", required=true)
    @XmlElement(name="wql", required=true)
    private List<WqlObj> m_wqlQueries = new ArrayList<WqlObj>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getFormatString() {
        return this.m_formatString;
    }

    public void setFormatString(String formatString) {
        this.m_formatString = ConfigUtils.assertNotEmpty(formatString, "formatString");
    }

    public List<WqlObj> getWqlObjs() {
        return this.m_wqlQueries;
    }

    public void setWqlObjs(List<WqlObj> wqlQueries) {
        ConfigUtils.assertMinimumSize(wqlQueries, 1L, "wql");
        if (wqlQueries == this.m_wqlQueries) {
            return;
        }
        this.m_wqlQueries.clear();
        if (wqlQueries != null) {
            this.m_wqlQueries.addAll(wqlQueries);
        }
    }

    public void addWqlObj(WqlObj wql) {
        this.m_wqlQueries.add(wql);
    }

    public boolean removeWqlObj(WqlObj wql) {
        return this.m_wqlQueries.remove(wql);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_formatString, this.m_wqlQueries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AssetField) {
            AssetField that = (AssetField)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_formatString, that.m_formatString) && Objects.equals(this.m_wqlQueries, that.m_wqlQueries);
        }
        return false;
    }
}

