/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.wmi.agent.Definition;

@XmlRootElement(name="wmi-config")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="wmi-config.xsd")
public class WmiConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="timeout")
    private Integer m_timeout;
    @XmlAttribute(name="retry")
    private Integer m_retry;
    @XmlAttribute(name="username")
    private String m_username;
    @XmlAttribute(name="domain")
    private String m_domain;
    @XmlAttribute(name="password")
    private String m_password;
    @XmlElement(name="definition")
    private List<Definition> m_definitions = new ArrayList<Definition>();

    public Optional<Integer> getTimeout() {
        return Optional.ofNullable(this.m_timeout);
    }

    public void setTimeout(Integer timeout) {
        this.m_timeout = timeout;
    }

    public Optional<Integer> getRetry() {
        return Optional.ofNullable(this.m_retry);
    }

    public void setRetry(Integer retry) {
        this.m_retry = retry;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.m_username);
    }

    public void setUsername(String username) {
        this.m_username = ConfigUtils.normalizeString(username);
    }

    public Optional<String> getDomain() {
        return Optional.ofNullable(this.m_domain);
    }

    public void setDomain(String domain) {
        this.m_domain = ConfigUtils.normalizeString(domain);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.m_password);
    }

    public void setPassword(String password) {
        this.m_password = ConfigUtils.normalizeString(password);
    }

    public List<Definition> getDefinitions() {
        return this.m_definitions;
    }

    public void setDefinitions(List<Definition> definitions) {
        if (definitions == this.m_definitions) {
            return;
        }
        this.m_definitions.clear();
        if (definitions != null) {
            this.m_definitions.addAll(definitions);
        }
    }

    public void addDefinition(Definition definition) {
        this.m_definitions.add(definition);
    }

    public boolean removeDefinition(Definition definition) {
        return this.m_definitions.remove(definition);
    }

    public int hashCode() {
        return Objects.hash(this.m_timeout, this.m_retry, this.m_username, this.m_domain, this.m_password, this.m_definitions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WmiConfig) {
            WmiConfig that = (WmiConfig)obj;
            return Objects.equals(this.m_timeout, that.m_timeout) && Objects.equals(this.m_retry, that.m_retry) && Objects.equals(this.m_username, that.m_username) && Objects.equals(this.m_domain, that.m_domain) && Objects.equals(this.m_password, that.m_password) && Objects.equals(this.m_definitions, that.m_definitions);
        }
        return false;
    }
}

