/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.viewsdisplay;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.viewsdisplay.View;

@XmlRootElement(name="viewinfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="viewsdisplay.xsd")
public class Viewinfo
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_DEFAULT_VIEW = "WebConsoleView";
    @XmlAttribute(name="disconnect-timeout")
    private Integer m_disconnectTimeout;
    @XmlAttribute(name="default-view")
    private String m_defaultView;
    @XmlElement(name="view")
    private List<View> m_views = new ArrayList<View>();

    public Integer getDisconnectTimeout() {
        return this.m_disconnectTimeout != null ? this.m_disconnectTimeout : 130000;
    }

    public void setDisconnectTimeout(Integer disconnectTimeout) {
        this.m_disconnectTimeout = disconnectTimeout;
    }

    public String getDefaultView() {
        return this.m_defaultView != null ? this.m_defaultView : DEFAULT_DEFAULT_VIEW;
    }

    public void setDefaultView(String defaultView) {
        this.m_defaultView = ConfigUtils.normalizeString(defaultView);
    }

    public List<View> getViews() {
        return this.m_views;
    }

    public void setViews(List<View> views) {
        if (views == this.m_views) {
            return;
        }
        this.m_views.clear();
        if (views != null) {
            this.m_views.addAll(views);
        }
    }

    public void addView(View view) {
        this.m_views.add(view);
    }

    public boolean removeView(View view) {
        return this.m_views.remove(view);
    }

    public int hashCode() {
        return Objects.hash(this.m_disconnectTimeout, this.m_defaultView, this.m_views);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Viewinfo) {
            Viewinfo that = (Viewinfo)obj;
            return Objects.equals(this.m_disconnectTimeout, that.m_disconnectTimeout) && Objects.equals(this.m_defaultView, that.m_defaultView) && Objects.equals(this.m_views, that.m_views);
        }
        return false;
    }
}

