/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support.osgi;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.opennms.netmgt.newts.support.RedisResourceMetadataCache;
import org.opennms.netmgt.newts.support.osgi.CacheFactory;
import org.opennms.newts.cassandra.search.ResourceIdSplitter;

public class RedisCacheFactory
implements CacheFactory<RedisResourceMetadataCache> {
    private final String hostname;
    private final int port;
    private final int numWriterThreads;
    private final MetricRegistry registry;
    private final ResourceIdSplitter resourceIdSplitter;

    public RedisCacheFactory(String hostname, int port, int numWriterThreads, MetricRegistry registry, ResourceIdSplitter resourceIdSplitter) {
        this.hostname = Objects.requireNonNull(hostname);
        this.port = port;
        this.numWriterThreads = numWriterThreads;
        this.registry = Objects.requireNonNull(registry);
        this.resourceIdSplitter = Objects.requireNonNull(resourceIdSplitter);
    }

    @Override
    public Class<RedisResourceMetadataCache> supportedType() {
        return RedisResourceMetadataCache.class;
    }

    @Override
    public RedisResourceMetadataCache createCache() {
        return new RedisResourceMetadataCache(this.hostname, this.port, this.numWriterThreads, this.registry, this.resourceIdSplitter);
    }
}

