/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class FunctionInvocation
extends Expression {
    private String functionName;
    private List argumentList;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String f) {
        this.functionName = f;
    }

    public List getArgumentList() {
        return this.argumentList;
    }

    public void setArgumentList(List l) {
        this.argumentList = l;
    }

    public FunctionInvocation(String functionName, List argumentList) {
        this.functionName = functionName;
        this.argumentList = argumentList;
    }

    @Override
    public String getExpressionString() {
        StringBuffer b = new StringBuffer();
        b.append(this.functionName);
        b.append("(");
        Iterator i = this.argumentList.iterator();
        while (i.hasNext()) {
            b.append(((Expression)i.next()).getExpressionString());
            if (!i.hasNext()) continue;
            b.append(", ");
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public Object evaluate(Object pContext, VariableResolver pResolver, Map functions, String defaultPrefix, Logger pLogger) throws ELException {
        Class<?>[] params;
        Method target;
        Object functionName;
        if (functions == null) {
            pLogger.logError(Constants.UNKNOWN_FUNCTION, this.functionName);
        }
        if (((String)(functionName = this.functionName)).indexOf(":") == -1) {
            if (defaultPrefix == null) {
                pLogger.logError(Constants.UNKNOWN_FUNCTION, functionName);
            }
            functionName = defaultPrefix + ":" + (String)functionName;
        }
        if ((target = (Method)functions.get(functionName)) == null) {
            pLogger.logError(Constants.UNKNOWN_FUNCTION, functionName);
        }
        if ((params = target.getParameterTypes()).length != this.argumentList.size()) {
            pLogger.logError(Constants.INAPPROPRIATE_FUNCTION_ARG_COUNT, new Integer(params.length), (Object)new Integer(this.argumentList.size()));
        }
        Object[] arguments = new Object[this.argumentList.size()];
        for (int i = 0; i < params.length; ++i) {
            arguments[i] = ((Expression)this.argumentList.get(i)).evaluate(pContext, pResolver, functions, defaultPrefix, pLogger);
            arguments[i] = Coercions.coerce(arguments[i], params[i], pLogger);
        }
        try {
            return target.invoke(null, arguments);
        }
        catch (InvocationTargetException ex) {
            pLogger.logError(Constants.FUNCTION_INVOCATION_ERROR, ex.getTargetException(), functionName);
            return null;
        }
        catch (Exception ex) {
            pLogger.logError(Constants.FUNCTION_INVOCATION_ERROR, ex, functionName);
            return null;
        }
    }
}

