/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import gnu.crypto.prng.ARCFour;
import gnu.crypto.prng.IRandom;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import rpc.security.ntlm.DigestHelper;
import rpc.security.ntlm.Responses;

final class NTLMKeyFactory {
    private static final Random RANDOM = new Random();

    private NTLMKeyFactory() {
    }

    static byte[] getNTLMUserSessionKey(String password) throws UnsupportedEncodingException, DigestException {
        byte[] ntlmHash = Responses.ntlmHash(password);
        return DigestHelper.md4(ntlmHash);
    }

    static byte[] getNTLMv2UserSessionKey(String target, String user, String password, byte[] challenge, byte[] blob) throws Exception {
        byte[] ntlm2Hash = Responses.ntlmv2Hash(target, user, password);
        byte[] data = new byte[challenge.length + blob.length];
        System.arraycopy(challenge, 0, data, 0, challenge.length);
        System.arraycopy(blob, 0, data, challenge.length, blob.length);
        byte[] mac = Responses.hmacMD5(data, ntlm2Hash);
        byte[] key = Responses.hmacMD5(mac, ntlm2Hash);
        return key;
    }

    static byte[] getNTLM2SessionResponseUserSessionKey(String password, byte[] servernonce) throws NoSuchAlgorithmException, UnsupportedEncodingException, DigestException {
        return Responses.hmacMD5(servernonce, NTLMKeyFactory.getNTLMUserSessionKey(password));
    }

    static byte[] getSecondarySessionKey() {
        byte[] key = new byte[16];
        RANDOM.nextBytes(key);
        return key;
    }

    static IRandom getARCFOUR(byte[] key) {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        ARCFour keystream = new ARCFour();
        attrib.put("gnu.crypto.prng.arcfour.key-material", key);
        keystream.init(attrib);
        return keystream;
    }

    static byte[] applyARCFOUR(IRandom keystream, byte[] data) {
        byte[] retData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            retData[i] = (byte)(data[i] ^ keystream.nextByte());
        }
        return retData;
    }

    static byte[] signingPt1(int sequenceNumber, byte[] signingKey, byte[] data, int lengthOfBuffer) throws NoSuchAlgorithmException {
        byte[] seqNumPlusData = new byte[4 + lengthOfBuffer];
        seqNumPlusData[0] = (byte)(sequenceNumber & 0xFF);
        seqNumPlusData[1] = (byte)(sequenceNumber >> 8 & 0xFF);
        seqNumPlusData[2] = (byte)(sequenceNumber >> 16 & 0xFF);
        seqNumPlusData[3] = (byte)(sequenceNumber >> 24 & 0xFF);
        System.arraycopy(data, 0, seqNumPlusData, 4, lengthOfBuffer);
        byte[] retval = new byte[16];
        retval[0] = 1;
        byte[] sign = Responses.hmacMD5(seqNumPlusData, signingKey);
        System.arraycopy(sign, 0, retval, 4, 8);
        retval[12] = (byte)(sequenceNumber & 0xFF);
        retval[13] = (byte)(sequenceNumber >> 8 & 0xFF);
        retval[14] = (byte)(sequenceNumber >> 16 & 0xFF);
        retval[15] = (byte)(sequenceNumber >> 24 & 0xFF);
        return retval;
    }

    static void signingPt2(byte[] verifier, IRandom rc4) {
        for (int i = 0; i < 8; ++i) {
            verifier[i + 4] = (byte)(verifier[i + 4] ^ rc4.nextByte());
        }
    }

    static boolean compareSignature(byte[] src, byte[] target) {
        return Arrays.equals(src, target);
    }
}

