/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;

public enum OsName {
    unknown(0),
    other(1),
    linux(2),
    windows(3),
    darwin(4),
    hpux(5),
    aix(6),
    dragonfly(7),
    freebsd(8),
    netbsd(9),
    openbsd(10),
    osf(11),
    solaris(12);

    public final int value;

    private OsName(int value) {
        this.value = value;
    }

    public static OsName from(ByteBuf buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuf)buffer);
        switch (value) {
            case 0: {
                return unknown;
            }
            case 1: {
                return other;
            }
            case 2: {
                return linux;
            }
            case 3: {
                return windows;
            }
            case 4: {
                return darwin;
            }
            case 5: {
                return hpux;
            }
            case 6: {
                return aix;
            }
            case 7: {
                return dragonfly;
            }
            case 8: {
                return freebsd;
            }
            case 9: {
                return netbsd;
            }
            case 10: {
                return openbsd;
            }
            case 11: {
                return osf;
            }
            case 12: {
                return solaris;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeInt32(this.value);
    }
}

