/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.perspectivepoller;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LocationUtils;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.PerspectiveResponseTimeResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.daemon.DaemonTools;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.api.ServicePerspective;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.perspectivepoller.PerspectivePollJob;
import org.opennms.netmgt.perspectivepoller.PerspectivePolledService;
import org.opennms.netmgt.perspectivepoller.PerspectiveServiceTracker;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.listeners.SchedulerListenerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="PerspectivePoller", logPrefix="perspectivepollerd")
public class PerspectivePollerd
implements SpringServiceDaemon,
PerspectiveServiceTracker.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(PerspectivePollerd.class);
    public static final String NAME = "PerspectivePoller";
    public static final String LOG_PREFIX = "perspectivepollerd";
    private final SessionUtils sessionUtils;
    private final MonitoringLocationDao monitoringLocationDao;
    private final PollerConfig pollerConfig;
    private final MonitoredServiceDao monitoredServiceDao;
    private final LocationAwarePollerClient locationAwarePollerClient;
    private final ApplicationDao applicationDao;
    private final CollectionAgentFactory collectionAgentFactory;
    private final PersisterFactory persisterFactory;
    private final EventForwarder eventForwarder;
    private final ThresholdingService thresholdingService;
    private final EventDao eventDao;
    private final OutageDao outageDao;
    private final TracerRegistry tracerRegistry;
    private final PerspectiveServiceTracker tracker;
    @VisibleForTesting
    Scheduler scheduler;
    private AutoCloseable trackerSession;

    @Autowired
    public PerspectivePollerd(SessionUtils sessionUtils, MonitoringLocationDao monitoringLocationDao, PollerConfig pollerConfig, MonitoredServiceDao monitoredServiceDao, LocationAwarePollerClient locationAwarePollerClient, ApplicationDao applicationDao, CollectionAgentFactory collectionAgentFactory, PersisterFactory persisterFactory, EventForwarder eventForwarder, ThresholdingService thresholdingService, EventDao eventDao, OutageDao outageDao, TracerRegistry tracerRegistry, PerspectiveServiceTracker tracker) {
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.monitoringLocationDao = Objects.requireNonNull(monitoringLocationDao);
        this.pollerConfig = Objects.requireNonNull(pollerConfig);
        this.monitoredServiceDao = Objects.requireNonNull(monitoredServiceDao);
        this.locationAwarePollerClient = Objects.requireNonNull(locationAwarePollerClient);
        this.applicationDao = Objects.requireNonNull(applicationDao);
        this.collectionAgentFactory = Objects.requireNonNull(collectionAgentFactory);
        this.persisterFactory = Objects.requireNonNull(persisterFactory);
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.thresholdingService = Objects.requireNonNull(thresholdingService);
        this.eventDao = Objects.requireNonNull(eventDao);
        this.outageDao = Objects.requireNonNull(outageDao);
        this.tracerRegistry = Objects.requireNonNull(tracerRegistry);
        this.tracerRegistry.init(SystemInfoUtils.getInstanceId());
        this.tracker = Objects.requireNonNull(tracker);
    }

    public void start() throws Exception {
        this.scheduler = new StdSchedulerFactory().getScheduler();
        this.scheduler.start();
        this.scheduler.getListenerManager().addSchedulerListener((SchedulerListener)new SchedulerListenerSupport(){

            public void schedulerError(String msg, SchedulerException cause) {
                LOG.error("Unexpected error during poll: {}", (Object)msg, (Object)cause);
            }
        });
        this.trackerSession = this.tracker.track(this);
    }

    public void destroy() throws Exception {
        this.trackerSession.close();
        this.trackerSession = null;
        this.scheduler.shutdown();
        this.scheduler = null;
    }

    @Override
    public void onServicePerspectiveAdded(PerspectiveServiceTracker.ServicePerspectiveRef servicePerspective, ServicePerspective entity) {
        ThresholdingSession thresholdingSession;
        JobKey key = PerspectivePollerd.buildJobKey(servicePerspective);
        OnmsMonitoredService service = entity.getService();
        OnmsIpInterface ipInterface = service.getIpInterface();
        OnmsNode node = ipInterface.getNode();
        this.pollerConfig.rebuildPackageIpListMap();
        Package pkg = this.pollerConfig.getPackages().stream().filter(p -> this.pollerConfig.isInterfaceInPackage(InetAddressUtils.str((InetAddress)service.getIpAddress()), p) && this.pollerConfig.isServiceInPackageAndEnabled(service.getServiceName(), p)).reduce((prev, curr) -> curr).orElse(null);
        if (pkg == null) {
            return;
        }
        Optional serviceMatch = pkg.findService(service.getServiceName());
        if (!serviceMatch.isPresent()) {
            return;
        }
        Optional serviceMonitorLocator = this.pollerConfig.getServiceMonitorLocator(((Package.ServiceMatch)serviceMatch.get()).service.getName());
        if (!serviceMonitorLocator.isPresent()) {
            return;
        }
        Optional<String> rrdRepositoryDir = Optional.ofNullable(this.getServiceParameter(((Package.ServiceMatch)serviceMatch.get()).service, "rrd-repository"));
        Optional<RrdRepository> rrdRepository = rrdRepositoryDir.map(directory -> {
            RrdRepository rrdRepositoryInstance = new RrdRepository();
            rrdRepositoryInstance.setStep(this.pollerConfig.getStep(pkg));
            rrdRepositoryInstance.setHeartBeat(rrdRepositoryInstance.getStep() * 2);
            rrdRepositoryInstance.setRraList(this.pollerConfig.getRRAList(pkg));
            rrdRepositoryInstance.setRrdBaseDir(new File((String)directory));
            return rrdRepositoryInstance;
        });
        try {
            thresholdingSession = this.thresholdingService.createSession(service.getNodeId().intValue(), InetAddressUtils.str((InetAddress)service.getIpAddress()), service.getServiceName(), new ServiceParameters(Collections.emptyMap()));
        }
        catch (ThresholdInitializationException ex) {
            LOG.error("Failed to create thresholding session", (Throwable)ex);
            return;
        }
        PerspectivePolledService perspectivePolledService = new PerspectivePolledService(service.getNodeId(), service.getIpAddress(), service.getServiceName(), node.getForeignSource(), node.getForeignId(), node.getLabel(), pkg, (Package.ServiceMatch)serviceMatch.get(), (ServiceMonitorLocator)serviceMonitorLocator.get(), servicePerspective.getPerspectiveLocation(), node.getLocation().getLocationName(), rrdRepository.orElse(null), thresholdingSession);
        JobDetail job = JobBuilder.newJob(PerspectivePollJob.class).withIdentity(key).setJobData(new JobDataMap((Map)ImmutableMap.builder().put((Object)"service", (Object)perspectivePolledService).put((Object)"backend", (Object)this).put((Object)"tracer", (Object)this.tracerRegistry.getTracer()).build())).build();
        Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(perspectivePolledService.getServiceConfig().getInterval().longValue()).repeatForever()).build();
        LOG.debug("Scheduling service named {} at location {} with interval {}ms", new Object[]{perspectivePolledService.getServiceName(), perspectivePolledService.getPerspectiveLocation(), perspectivePolledService.getServiceConfig().getInterval()});
        try {
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            LOG.error("Failed to schedule {} ({}).", new Object[]{perspectivePolledService, key, e});
        }
    }

    @Override
    public void onServicePerspectiveRemoved(PerspectiveServiceTracker.ServicePerspectiveRef servicePerspective) {
        JobKey key = PerspectivePollerd.buildJobKey(servicePerspective);
        try {
            this.scheduler.deleteJob(key);
        }
        catch (SchedulerException e) {
            LOG.error("Failed to un-schedule {} ({}).", new Object[]{servicePerspective, key, e});
        }
        OnmsMonitoredService service = this.monitoredServiceDao.get(Integer.valueOf(servicePerspective.getNodeId()), servicePerspective.getIpAddress(), servicePerspective.getServiceName());
        if (service == null) {
            return;
        }
        OnmsMonitoringLocation perspectiveLocation = (OnmsMonitoringLocation)this.monitoringLocationDao.get((Serializable)((Object)servicePerspective.getPerspectiveLocation()));
        if (perspectiveLocation == null) {
            return;
        }
        OnmsOutage outage = this.outageDao.currentOutageForServiceFromPerspective(service, perspectiveLocation);
        if (outage == null) {
            return;
        }
        outage.setIfRegainedService(new Date());
        this.outageDao.update((Object)outage);
    }

    public static JobKey buildJobKey(PerspectiveServiceTracker.ServicePerspectiveRef servicePerspective) {
        return PerspectivePollerd.buildJobKey(servicePerspective.getNodeId(), servicePerspective.getIpAddress(), servicePerspective.getServiceName(), servicePerspective.getPerspectiveLocation());
    }

    public static JobKey buildJobKey(int nodeId, InetAddress ipAddress, String serviceName, String perspectiveLocation) {
        String name = String.format("%s-%s-%s", nodeId, InetAddressUtils.str((InetAddress)ipAddress), serviceName);
        return new JobKey(name, perspectiveLocation);
    }

    public LocationAwarePollerClient getLocationAwarePollerClient() {
        return this.locationAwarePollerClient;
    }

    protected void reportResult(PerspectivePolledService polledService, PollStatus pollResult) {
        if (!polledService.updateStatus(pollResult)) {
            return;
        }
        String uei = pollResult.isAvailable() ? "uei.opennms.org/perspective/nodes/nodeRegainedService" : "uei.opennms.org/perspective/nodes/nodeLostService";
        EventBuilder builder = new EventBuilder(uei, NAME);
        builder.addParam("location", polledService.getPerspectiveLocation());
        builder.setNodeid((long)polledService.getNodeId());
        builder.setInterface(polledService.getIpAddress());
        builder.setService(polledService.getServiceName());
        builder.addParam("perspective", polledService.getPerspectiveLocation());
        if (!pollResult.isAvailable() && pollResult.getReason() != null) {
            builder.addParam("eventReason", pollResult.getReason());
        }
        this.eventForwarder.sendNow(builder.getEvent());
    }

    public void persistResponseTimeData(PerspectivePolledService polledService, PollStatus pollStatus) {
        HashMap properties;
        String rrdBaseName;
        if (polledService.getRrdRepository() == null) {
            return;
        }
        String dsName = this.getServiceParameter(polledService.getServiceConfig(), "ds-name");
        if (dsName == null) {
            dsName = "response-time";
        }
        if ((rrdBaseName = this.getServiceParameter(polledService.getServiceConfig(), "rrd-base-name")) == null) {
            rrdBaseName = dsName;
        }
        if (!(properties = Maps.newHashMap((Map)pollStatus.getProperties())).containsKey(dsName) && properties.containsKey("response-time")) {
            properties.put(dsName, (Number)properties.get("response-time"));
            properties.remove("response-time");
        }
        CollectionAgentDTO agent = new CollectionAgentDTO();
        agent.setAddress(polledService.getIpAddress());
        agent.setForeignId(polledService.getForeignId());
        agent.setForeignSource(polledService.getForeignSource());
        agent.setNodeId(polledService.getNodeId());
        agent.setNodeLabel(polledService.getNodeLabel());
        agent.setLocationName(polledService.getPerspectiveLocation());
        agent.setStorageResourcePath(ResourcePath.get((ResourcePath)(LocationUtils.isDefaultLocationName((String)polledService.getResidentLocation()) ? ResourcePath.get((String[])new String[0]) : ResourcePath.get((String[])new String[]{ResourcePath.sanitize((String)polledService.getResidentLocation())})), (String[])new String[]{InetAddressUtils.str((InetAddress)polledService.getIpAddress())}));
        agent.setStoreByForeignSource(Boolean.valueOf(false));
        CollectionSetBuilder collectionSetBuilder = new CollectionSetBuilder((CollectionAgent)agent);
        PerspectiveResponseTimeResource resource = new PerspectiveResponseTimeResource(polledService.getPerspectiveLocation(), InetAddressUtils.str((InetAddress)polledService.getIpAddress()), polledService.getServiceName());
        for (Map.Entry e : properties.entrySet()) {
            String key = "response-time".equals(e.getKey()) ? dsName : (String)e.getKey();
            collectionSetBuilder.withGauge((Resource)resource, rrdBaseName, key, (Number)e.getValue());
        }
        CollectionSetDTO collectionSetDTO = collectionSetBuilder.build();
        collectionSetDTO.visit((CollectionSetVisitor)this.persisterFactory.createPersister(new ServiceParameters(Collections.emptyMap()), polledService.getRrdRepository(), false, true, true));
        try {
            if (polledService.getThresholdingSession() != null) {
                polledService.getThresholdingSession().accept((CollectionSet)collectionSetDTO);
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to threshold on {} for {} because of an exception", new Object[]{polledService, dsName, e});
        }
    }

    private String getServiceParameter(Service service, String key) {
        for (Parameter parm : this.pollerConfig.parameters(service)) {
            if (!key.equals(parm.getKey())) continue;
            if (parm.getValue() != null) {
                return parm.getValue();
            }
            if (parm.getAnyObject() == null) continue;
            return parm.getAnyObject().toString();
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadDaemonConfig(IEvent event) {
        DaemonTools.handleReloadEvent((IEvent)event, (String)NAME, ev -> {
            try {
                this.pollerConfig.update();
                this.destroy();
                this.start();
            }
            catch (Exception e) {
                LOG.error("Failed to reload poller configuration", (Throwable)e);
            }
        });
    }

    @EventHandler(uei="uei.opennms.org/perspective/nodes/nodeLostService")
    public void handlePerspectiveNodeLostService(IEvent e) {
        if (e.hasNodeid() && e.getInterfaceAddress() != null && e.getService() != null && e.getParm("perspective") != null) {
            OnmsEvent onmsEvent = (OnmsEvent)this.eventDao.get((Serializable)e.getDbid());
            OnmsMonitoredService service = this.monitoredServiceDao.get(onmsEvent.getNodeId(), onmsEvent.getIpAddr(), onmsEvent.getServiceType().getId());
            OnmsMonitoringLocation perspective = (OnmsMonitoringLocation)this.monitoringLocationDao.get((Serializable)((Object)e.getParm("perspective").getValue().getContent()));
            OnmsOutage onmsOutage = new OnmsOutage(onmsEvent.getEventCreateTime(), onmsEvent, service);
            onmsOutage.setPerspective(perspective);
            this.outageDao.save((Object)onmsOutage);
            Event outageEvent = new EventBuilder("uei.opennms.org/internal/poller/outageCreated", NAME).setNodeid((long)onmsEvent.getNodeId().intValue()).setInterface(onmsEvent.getIpAddr()).setService(service.getServiceName()).setTime(onmsEvent.getEventCreateTime()).setParam("perspective", perspective.getLocationName()).getEvent();
            this.eventForwarder.sendNow(outageEvent);
        } else {
            LOG.warn("Received incomplete {} event: {}", (Object)"uei.opennms.org/perspective/nodes/nodeLostService", (Object)e);
        }
    }

    @EventHandler(uei="uei.opennms.org/perspective/nodes/nodeRegainedService")
    public void handlePerspectiveNodeGainedService(IEvent e) {
        if (e.hasNodeid() && e.getInterfaceAddress() != null && e.getService() != null && e.getParm("perspective") != null) {
            OnmsEvent onmsEvent = (OnmsEvent)this.eventDao.get((Serializable)e.getDbid());
            OnmsMonitoredService service = this.monitoredServiceDao.get(onmsEvent.getNodeId(), onmsEvent.getIpAddr(), onmsEvent.getServiceType().getId());
            OnmsMonitoringLocation perspective = (OnmsMonitoringLocation)this.monitoringLocationDao.get((Serializable)((Object)e.getParm("perspective").getValue().getContent()));
            Criteria criteria = new CriteriaBuilder(OnmsOutage.class).eq("perspective", (Object)perspective).isNull("serviceRegainedEvent").isNull("ifRegainedService").eq("monitoredService", (Object)service).toCriteria();
            List onmsOutages = this.outageDao.findMatching(criteria);
            if (onmsOutages.size() == 1) {
                OnmsOutage onmsOutage = (OnmsOutage)onmsOutages.get(0);
                onmsOutage.setIfRegainedService(onmsEvent.getEventCreateTime());
                onmsOutage.setServiceRegainedEvent(onmsEvent);
                this.outageDao.update((Object)onmsOutage);
                Event outageEvent = new EventBuilder("uei.opennms.org/internal/poller/outageResolved", NAME).setNodeid((long)onmsEvent.getNodeId().intValue()).setInterface(onmsEvent.getIpAddr()).setService(service.getServiceName()).setTime(onmsEvent.getEventCreateTime()).setParam("perspective", perspective.getLocationName()).getEvent();
                this.eventForwarder.sendNow(outageEvent);
            } else {
                LOG.warn("Found more than one outages for {} event: {}", (Object)"uei.opennms.org/perspective/nodes/nodeRegainedService", (Object)e);
            }
        } else {
            LOG.warn("Received incomplete {} event: {}", (Object)"uei.opennms.org/perspective/nodes/nodeRegainedService", (Object)e);
        }
    }
}

