/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd.jmx;

import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTrapMetricsRegistry<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceTrapMetricsRegistry.class);
    private static final String JMX_DOMAIN = "org.opennms.netmgt.trapd.device";
    private final boolean enabled;
    private final String mbeanType;
    private final DeviceMetricsFactory<T> factory;
    private final MBeanServer mbeanServer;
    private final ConcurrentHashMap<DeviceKey, T> deviceMetrics = new ConcurrentHashMap();

    public DeviceTrapMetricsRegistry(boolean enabled, DeviceMetricsFactory<T> factory, String mbeanType) {
        this.enabled = enabled;
        this.factory = factory;
        this.mbeanType = mbeanType;
        if (enabled) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            LOG.info("Per-device trap metrics enabled (type='{}') under JMX domain '{}'", (Object)mbeanType, (Object)JMX_DOMAIN);
        } else {
            this.mbeanServer = null;
        }
    }

    public T getOrCreate(String location, String ipAddress) {
        if (!this.enabled) {
            return null;
        }
        DeviceKey key = new DeviceKey(location, ipAddress);
        return (T)this.deviceMetrics.computeIfAbsent(key, k -> {
            T metrics = this.factory.create(location, ipAddress);
            this.registerMBean(metrics, location, ipAddress);
            return metrics;
        });
    }

    private void registerMBean(T metrics, String location, String ipAddress) {
        try {
            ObjectName objectName = new ObjectName("org.opennms.netmgt.trapd.device:location=" + ObjectName.quote(location) + ",ip=" + ObjectName.quote(ipAddress) + ",type=" + this.mbeanType);
            this.mbeanServer.registerMBean(metrics, objectName);
            LOG.debug("Registered per-device MBean: {}", (Object)objectName);
        }
        catch (Exception e) {
            LOG.warn("Failed to register per-device MBean for location='{}', ip='{}'", new Object[]{location, ipAddress, e});
        }
    }

    public void shutdown() {
        for (DeviceKey key : this.deviceMetrics.keySet()) {
            this.unregisterMBean(key.location, key.ipAddress);
        }
        this.deviceMetrics.clear();
        LOG.info("Per-device trap metrics registry shut down");
    }

    private void unregisterMBean(String location, String ipAddress) {
        try {
            ObjectName objectName = new ObjectName("org.opennms.netmgt.trapd.device:location=" + ObjectName.quote(location) + ",ip=" + ObjectName.quote(ipAddress) + ",type=" + this.mbeanType);
            if (this.mbeanServer != null && this.mbeanServer.isRegistered(objectName)) {
                this.mbeanServer.unregisterMBean(objectName);
                LOG.debug("Unregistered per-device MBean: {}", (Object)objectName);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister per-device MBean for location='{}', ip='{}'", new Object[]{location, ipAddress, e});
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @FunctionalInterface
    public static interface DeviceMetricsFactory<T> {
        public T create(String var1, String var2);
    }

    private static final class DeviceKey {
        final String location;
        final String ipAddress;

        DeviceKey(String location, String ipAddress) {
            this.location = location;
            this.ipAddress = ipAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeviceKey)) {
                return false;
            }
            DeviceKey that = (DeviceKey)o;
            return Objects.equals(this.location, that.location) && Objects.equals(this.ipAddress, that.ipAddress);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.ipAddress);
        }
    }
}

