/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd.jmx;

import java.util.concurrent.atomic.AtomicLong;
import org.opennms.netmgt.trapd.jmx.DeviceConsumerTrapMetricsMBean;

public class DeviceConsumerTrapMetrics
implements DeviceConsumerTrapMetricsMBean {
    private final String location;
    private final String ipAddress;
    private final AtomicLong trapsReceived = new AtomicLong();
    private final AtomicLong trapsDiscarded = new AtomicLong();
    private final AtomicLong trapsErrored = new AtomicLong();

    public DeviceConsumerTrapMetrics(String location, String ipAddress) {
        this.location = location;
        this.ipAddress = ipAddress;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public String getDeviceId() {
        return this.location + ":" + this.ipAddress;
    }

    @Override
    public long getTrapsReceived() {
        return this.trapsReceived.get();
    }

    @Override
    public long getTrapsDiscarded() {
        return this.trapsDiscarded.get();
    }

    @Override
    public long getTrapsErrored() {
        return this.trapsErrored.get();
    }

    public void incTrapsReceived() {
        this.trapsReceived.incrementAndGet();
    }

    public void incTrapsDiscarded() {
        this.trapsDiscarded.incrementAndGet();
    }

    public void incTrapsErrored() {
        this.trapsErrored.incrementAndGet();
    }
}

