/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.grafana;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

public class GrafanaQuery {
    private final String dashboardUid;
    private final int width;
    private final int height;
    private final String theme;
    private final Date from;
    private final Date to;
    private String timezone;
    private final Map<String, String> variables;

    public GrafanaQuery(String queryString) {
        JsonParser parser = new JsonParser();
        JsonObject jo = (JsonObject)parser.parse(queryString);
        JsonObject dashboard = jo.getAsJsonObject("dashboard");
        this.dashboardUid = dashboard.getAsJsonPrimitive("uid").getAsString();
        JsonObject time = jo.getAsJsonObject("time");
        this.from = new Date(time.getAsJsonPrimitive("from").getAsLong());
        this.to = new Date(time.getAsJsonPrimitive("to").getAsLong());
        if (time.has("tz")) {
            this.timezone = time.getAsJsonPrimitive("tz").getAsString();
        }
        JsonObject render = jo.getAsJsonObject("render");
        this.width = render.getAsJsonPrimitive("width").getAsInt();
        this.height = render.getAsJsonPrimitive("height").getAsInt();
        this.theme = render.getAsJsonPrimitive("theme").getAsString();
        JsonObject vars = jo.getAsJsonObject("variables");
        this.variables = vars != null ? vars.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> vars.getAsJsonPrimitive((String)e.getKey()).getAsString())) : Collections.emptyMap();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getDashboardUid() {
        return this.dashboardUid;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public Date getFrom() {
        return this.from;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Date getTo() {
        return this.to;
    }

    public String getTheme() {
        return this.theme;
    }
}

