/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.nxos.adapter;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.protocols.nxos.adapter.proto.TelemetryBis;

public class NxosTelemetryClient {
    private static TelemetryBis.Telemetry buildMessage(String ipAddress, int i) throws IOException {
        TelemetryBis.TelemetryField field1 = TelemetryBis.TelemetryField.newBuilder().setName("loadavg").setUint32Value(i + 32).setTimestamp(1510584351L).build();
        TelemetryBis.Telemetry telemetrymsg = TelemetryBis.Telemetry.newBuilder().setNodeIdStr(ipAddress).addDataGpbkv(field1).setSubscriptionIdStr("18374686715878047745").setCollectionId(10456L).setCollectionStartTime(1510584351L).setCollectionEndTime(1510584402L).setMsgTimestamp(new Date().getTime()).build();
        return telemetrymsg;
    }

    public static void main(String ... args) throws IOException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            numbers.add(i2);
        }
        numbers.parallelStream().forEach(i -> {
            try {
                NxosTelemetryClient.sendNxosPacket(i);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static void sendNxosPacket(int i) throws IOException {
        TelemetryBis.Telemetry nxosMsg = NxosTelemetryClient.buildMessage("192.168.0.106", i);
        byte[] nxosMsgBytes = nxosMsg.toByteArray();
        InetAddress address = InetAddressUtils.getLocalHostAddress();
        DatagramPacket packet = new DatagramPacket(nxosMsgBytes, nxosMsgBytes.length, address, 50001);
        DatagramSocket socket = new DatagramSocket();
        socket.send(packet);
    }
}

