/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.api;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import org.opennms.core.rpc.api.RequestRejectedException;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.core.rpc.api.RpcExceptionHandler;

public class RpcExceptionUtils {
    public static <T> T handleException(Throwable t, RpcExceptionHandler<T> visitor) {
        Objects.requireNonNull(t);
        Objects.requireNonNull(visitor);
        Optional<Object> val = RpcExceptionUtils.handleExceptionInternal(t, visitor);
        if (val != null) {
            return val.orElse(null);
        }
        Throwable cause = t.getCause();
        if (cause != null && (val = RpcExceptionUtils.handleExceptionInternal(cause, visitor)) != null) {
            return val.orElse(null);
        }
        return visitor.onUnknown(t);
    }

    private static <T> Optional<T> handleExceptionInternal(Throwable t, RpcExceptionHandler<T> visitor) {
        if (t instanceof InterruptedException) {
            return Optional.ofNullable(visitor.onInterrupted(t));
        }
        if (t instanceof RequestRejectedException) {
            return Optional.ofNullable(visitor.onRejected(t));
        }
        if (t instanceof RejectedExecutionException) {
            return Optional.ofNullable(visitor.onRejected(t));
        }
        if (t instanceof RequestTimedOutException) {
            return Optional.ofNullable(visitor.onTimedOut(t));
        }
        return null;
    }
}

