/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.support;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;

public class MultilineOrientedResponseDecoder
extends MessageToMessageDecoder<Object> {
    public static final String DEFAULT_MULTILINE_INDICATOR = "-";
    private final String m_multilineIndicator;
    private MultilineOrientedResponse m_response;

    public MultilineOrientedResponseDecoder() {
        this(DEFAULT_MULTILINE_INDICATOR);
    }

    public MultilineOrientedResponseDecoder(String multilineIndicator) {
        this.m_multilineIndicator = multilineIndicator;
    }

    protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> messages) throws Exception {
        if (!(msg instanceof String)) {
            messages.add(msg);
        }
        if (this.m_response == null) {
            this.m_response = new MultilineOrientedResponse();
        }
        String response = (String)msg;
        this.m_response.addLine(response);
        if (!this.checkIndicator(response)) {
            MultilineOrientedResponse retval = this.m_response;
            this.m_response = null;
            messages.add(retval);
        }
    }

    protected boolean checkIndicator(String line) {
        return line.substring(3, 4).equals(this.getMultilineIndicator());
    }

    public String getMultilineIndicator() {
        return this.m_multilineIndicator;
    }
}

