/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.collectors.resource.NumericAttribute;

public final class ImmutableNumericAttribute
implements NumericAttribute {
    private final String name;
    private final String group;
    private final Double value;
    private final NumericAttribute.Type type;

    private ImmutableNumericAttribute(Builder builder) {
        this.name = builder.name;
        this.group = builder.group;
        this.value = builder.value;
        this.type = builder.type;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(NumericAttribute numericAttribute) {
        return new Builder(numericAttribute);
    }

    public static NumericAttribute immutableCopy(NumericAttribute numericAttribute) {
        if (numericAttribute == null || numericAttribute instanceof ImmutableNumericAttribute) {
            return numericAttribute;
        }
        return ImmutableNumericAttribute.newBuilderFrom(numericAttribute).build();
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public NumericAttribute.Type getType() {
        return this.type;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableNumericAttribute that = (ImmutableNumericAttribute)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.group, that.group) && Objects.equals(this.value, that.value) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.group, this.value, this.type);
    }

    public String toString() {
        return "ImmutableNumericAttribute{name='" + this.name + "', group='" + this.group + "', value=" + this.value + ", type=" + this.type + "}";
    }

    public static final class Builder {
        private String name;
        private String group;
        private Double value;
        private NumericAttribute.Type type;

        private Builder() {
        }

        private Builder(NumericAttribute numericAttribute) {
            this.name = numericAttribute.getName();
            this.group = numericAttribute.getGroup();
            this.value = numericAttribute.getValue();
            this.type = numericAttribute.getType();
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder setGroup(String group) {
            this.group = Objects.requireNonNull(group);
            return this;
        }

        public Builder setValue(Double value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        public Builder setType(NumericAttribute.Type type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public ImmutableNumericAttribute build() {
            Objects.requireNonNull(this.name, "name is required");
            Objects.requireNonNull(this.group, "group is required");
            Objects.requireNonNull(this.type, "type is required");
            Objects.requireNonNull(this.value, "numericValue is required");
            return new ImmutableNumericAttribute(this);
        }
    }
}

