/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.api;

import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.collection.adapters.AttributeTypeAdapter;

@XmlJavaTypeAdapter(value=AttributeTypeAdapter.class)
public enum AttributeType {
    GAUGE("gauge", true, "gauge32", "integer32"),
    COUNTER("counter", true, "counter32"),
    STRING("string", false, new String[0]);

    private final String m_name;
    private final boolean m_isNumeric;
    private final String[] m_aliases;

    private AttributeType(String name, boolean isNumeric, String ... aliases) {
        this.m_name = name;
        this.m_isNumeric = isNumeric;
        this.m_aliases = aliases;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isNumeric() {
        return this.m_isNumeric;
    }

    public String[] getAliases() {
        return this.m_aliases;
    }

    public static AttributeType parse(String typeAsString) {
        for (AttributeType type : AttributeType.values()) {
            if (type.getName().equalsIgnoreCase(typeAsString)) {
                return type;
            }
            for (String alias : type.getAliases()) {
                if (!alias.equalsIgnoreCase(typeAsString)) continue;
                return type;
            }
        }
        return null;
    }
}

