/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.service.util;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class OpenAPIConfigHelper {
    private OpenAPIConfigHelper() {
    }

    public static void fillWithDefaultValue(OpenAPI openapi, String topLevelElement, JSONObject configJsonObj) {
        if (openapi == null) {
            return;
        }
        Map schemaMap = openapi.getComponents().getSchemas();
        Schema rootSchema = (Schema)schemaMap.get(topLevelElement);
        if (rootSchema == null) {
            return;
        }
        for (Map.Entry entry : rootSchema.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            Schema schema = (Schema)entry.getValue();
            if (!configJsonObj.has(key)) {
                OpenAPIConfigHelper.fillSingleValue(key, configJsonObj, schema, openapi, true);
                continue;
            }
            Object property = configJsonObj.get(key);
            if (property instanceof JSONObject) {
                JSONObject object = (JSONObject)property;
                OpenAPIConfigHelper.fillSingleValue(key, object, schema, openapi, false);
                continue;
            }
            if (!(property instanceof JSONArray)) continue;
            for (Object item : (JSONArray)property) {
                if (!(item instanceof JSONObject) || !(schema instanceof ArraySchema)) continue;
                String schemaName = ((ArraySchema)schema).getItems().get$ref().replaceAll("^#/components/schemas/", "");
                OpenAPIConfigHelper.fillWithDefaultValue(openapi, schemaName, (JSONObject)item);
            }
        }
    }

    private static void fillSingleValue(String key, JSONObject configJsonObj, Schema<?> propertySchema, OpenAPI openapi, boolean isNewObject) {
        if (propertySchema instanceof ArraySchema) {
            configJsonObj.put(key, (Object)new JSONArray());
        } else if (OpenAPIConfigHelper.isSimpleDataType(propertySchema)) {
            if (propertySchema.getDefault() != null) {
                configJsonObj.put(key, propertySchema.getDefault());
            }
        } else if (propertySchema instanceof Schema && propertySchema.get$ref() != null) {
            String schemaName = propertySchema.get$ref().replaceAll("^#/components/schemas/", "");
            if (isNewObject) {
                JSONObject children = new JSONObject();
                OpenAPIConfigHelper.fillWithDefaultValue(openapi, schemaName, children);
                if (children.length() > 0) {
                    configJsonObj.put(key, (Object)children);
                }
            } else {
                OpenAPIConfigHelper.fillWithDefaultValue(openapi, schemaName, configJsonObj);
            }
        } else {
            configJsonObj.put(key, null);
        }
    }

    private static boolean isSimpleDataType(Schema schema) {
        return schema instanceof StringSchema || schema instanceof NumberSchema || schema instanceof IntegerSchema || schema instanceof DateSchema || schema instanceof DateTimeSchema || schema instanceof BooleanSchema;
    }
}

