/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.jasperreports.svclayer;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.fill.JRParameterDefaultValuesEvaluator;
import net.sf.jasperreports.engine.util.JRElementsVisitor;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRVisitorSupport;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.opennms.api.reporting.ReportException;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportService;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportDoubleParm;
import org.opennms.api.reporting.parameter.ReportFloatParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.api.reporting.parameter.ReportStringParm;
import org.opennms.api.reporting.parameter.ReportTimezoneParm;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.jexl.OnmsJexlEngine;
import org.opennms.features.reporting.repository.global.GlobalReportRepository;
import org.opennms.reporting.jasperreports.compiler.CustomJRJdtCompiler;
import org.opennms.reporting.jasperreports.filter.ParameterFilter;
import org.opennms.reporting.jasperreports.svclayer.SubreportExpressionVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JasperReportService
implements ReportService {
    private static final Logger LOG = LoggerFactory.getLogger(JasperReportService.class);
    private static final String LOG4J_CATEGORY = "reports";
    private static final String STRING_INPUT_TYPE = "org.opennms.report.stringInputType";
    private GlobalReportRepository m_globalReportRepository;
    private final List<ParameterFilter> parameterFilters = new ArrayList<ParameterFilter>();

    public JasperReportService() {
        Iterator<ParameterFilter> it = ServiceLoader.load(ParameterFilter.class).iterator();
        while (it.hasNext()) {
            this.parameterFilters.add(it.next());
        }
    }

    public List<ReportFormat> getFormats(String reportId) {
        ArrayList<ReportFormat> formats = new ArrayList<ReportFormat>();
        formats.add(ReportFormat.PDF);
        formats.add(ReportFormat.CSV);
        return formats;
    }

    public ReportParameters getParameters(final String reportId) throws ReportException {
        try {
            return (ReportParameters)Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<ReportParameters>(){

                @Override
                public ReportParameters call() throws Exception {
                    ReportParameters reportParameters = new ReportParameters();
                    JasperReport jasperReport = JasperReportService.this.getJasperReport(reportId);
                    Map defaultValues = JRParameterDefaultValuesEvaluator.evaluateParameterDefaultValues((JasperReport)jasperReport, new HashMap());
                    JRParameter[] reportParms = jasperReport.getParameters();
                    ArrayList<ReportIntParm> intParms = new ArrayList<ReportIntParm>();
                    reportParameters.setIntParms(intParms);
                    ArrayList<ReportFloatParm> floatParms = new ArrayList<ReportFloatParm>();
                    reportParameters.setFloatParms(floatParms);
                    ArrayList<ReportDoubleParm> doubleParms = new ArrayList<ReportDoubleParm>();
                    reportParameters.setDoubleParms(doubleParms);
                    ArrayList<ReportStringParm> stringParms = new ArrayList<ReportStringParm>();
                    reportParameters.setStringParms(stringParms);
                    ArrayList<ReportDateParm> dateParms = new ArrayList<ReportDateParm>();
                    reportParameters.setDateParms(dateParms);
                    ArrayList<ReportTimezoneParm> timezoneParms = new ArrayList<ReportTimezoneParm>();
                    reportParameters.setTimezoneParms(timezoneParms);
                    for (JRParameter reportParm : reportParms) {
                        if (JasperReportService.this.apply(JasperReportService.this.parameterFilters, reportParm)) {
                            if (reportParm.getValueClassName().equals("java.lang.String")) {
                                LOG.debug("adding a string parm name {}", (Object)reportParm.getName());
                                ReportStringParm stringParm = new ReportStringParm();
                                if (reportParm.getDescription() != null) {
                                    stringParm.setDisplayName(reportParm.getDescription());
                                } else {
                                    stringParm.setDisplayName(reportParm.getName());
                                }
                                if (reportParm.getPropertiesMap().containsProperty(JasperReportService.STRING_INPUT_TYPE)) {
                                    stringParm.setInputType(reportParm.getPropertiesMap().getProperty(JasperReportService.STRING_INPUT_TYPE));
                                }
                                stringParm.setName(reportParm.getName());
                                if (defaultValues.containsKey(reportParm.getName()) && defaultValues.get(reportParm.getName()) != null) {
                                    stringParm.setValue((String)defaultValues.get(reportParm.getName()));
                                } else {
                                    stringParm.setValue("");
                                }
                                stringParms.add(stringParm);
                                continue;
                            }
                            if (reportParm.getValueClassName().equals("java.lang.Integer")) {
                                LOG.debug("adding a Integer parm name {}", (Object)reportParm.getName());
                                ReportIntParm intParm = new ReportIntParm();
                                if (reportParm.getDescription() != null) {
                                    intParm.setDisplayName(reportParm.getDescription());
                                } else {
                                    intParm.setDisplayName(reportParm.getName());
                                }
                                intParm.setName(reportParm.getName());
                                if (defaultValues.containsKey(reportParm.getName()) && defaultValues.get(reportParm.getName()) != null) {
                                    intParm.setValue(((Integer)defaultValues.get(reportParm.getName())).intValue());
                                } else {
                                    intParm.setValue(0);
                                }
                                intParms.add(intParm);
                                continue;
                            }
                            if (reportParm.getValueClassName().equals("java.time.ZoneId")) {
                                LOG.debug("adding a ZoneId parm name {}", (Object)reportParm.getName());
                                ReportTimezoneParm timezoneParm = new ReportTimezoneParm();
                                timezoneParm.setName(reportParm.getName());
                                if (reportParm.getDescription() != null) {
                                    timezoneParm.setDisplayName(reportParm.getDescription());
                                } else {
                                    timezoneParm.setDisplayName(reportParm.getName());
                                }
                                if (defaultValues.containsKey(reportParm.getName()) && defaultValues.get(reportParm.getName()) != null) {
                                    Object timezoneValue = defaultValues.get(reportParm.getName());
                                    if (timezoneValue instanceof ZoneId) {
                                        timezoneParm.setValue((ZoneId)timezoneValue);
                                    } else if (timezoneValue instanceof String && !Strings.isNullOrEmpty((String)((String)timezoneValue))) {
                                        timezoneParm.setValue((String)timezoneValue);
                                    }
                                }
                                timezoneParms.add(timezoneParm);
                                continue;
                            }
                            if (reportParm.getValueClassName().equals("java.lang.Float")) {
                                LOG.debug("adding a Float parm name {}", (Object)reportParm.getName());
                                ReportFloatParm floatParm = new ReportFloatParm();
                                if (reportParm.getDescription() != null) {
                                    floatParm.setDisplayName(reportParm.getDescription());
                                } else {
                                    floatParm.setDisplayName(reportParm.getName());
                                }
                                floatParm.setName(reportParm.getName());
                                if (defaultValues.containsKey(reportParm.getName()) && defaultValues.get(reportParm.getName()) != null) {
                                    floatParm.setValue((Float)defaultValues.get(reportParm.getName()));
                                } else {
                                    floatParm.setValue(new Float(0.0f));
                                }
                                floatParms.add(floatParm);
                                continue;
                            }
                            if (reportParm.getValueClassName().equals("java.lang.Double")) {
                                LOG.debug("adding a Double parm name {}", (Object)reportParm.getName());
                                ReportDoubleParm doubleParm = new ReportDoubleParm();
                                if (reportParm.getDescription() != null) {
                                    doubleParm.setDisplayName(reportParm.getDescription());
                                } else {
                                    doubleParm.setDisplayName(reportParm.getName());
                                }
                                doubleParm.setName(reportParm.getName());
                                if (defaultValues.containsKey(reportParm.getName()) && defaultValues.get(reportParm.getName()) != null) {
                                    doubleParm.setValue((Double)defaultValues.get(reportParm.getName()));
                                } else {
                                    doubleParm.setValue(Double.valueOf(0.0));
                                }
                                doubleParms.add(doubleParm);
                                continue;
                            }
                            if (reportParm.getValueClassName().equals("java.util.Date") || reportParm.getValueClassName().equals("java.sql.Date") || reportParm.getValueClassName().equals("java.sql.Timestamp")) {
                                LOG.debug("adding a {} parm name {}", (Object)reportParm.getValueClassName(), (Object)reportParm.getName());
                                ReportDateParm dateParm = new ReportDateParm();
                                dateParm.setUseAbsoluteDate(Boolean.valueOf(false));
                                if (reportParm.getDescription() != null) {
                                    dateParm.setDisplayName(reportParm.getDescription());
                                } else {
                                    dateParm.setDisplayName(reportParm.getName());
                                }
                                dateParm.setName(reportParm.getName());
                                dateParm.setCount(Integer.valueOf(1));
                                dateParm.setInterval("day");
                                dateParm.setHours(Integer.valueOf(0));
                                dateParm.setMinutes(Integer.valueOf(0));
                                if (defaultValues.containsKey(reportParm.getName()) && defaultValues.get(reportParm.getName()) != null) {
                                    dateParm.setDate((java.util.Date)defaultValues.get(reportParm.getName()));
                                    cal = Calendar.getInstance();
                                    cal.setTime(dateParm.getDate());
                                    dateParm.setMinutes(Integer.valueOf(cal.get(12)));
                                    dateParm.setHours(Integer.valueOf(cal.get(11)));
                                } else {
                                    cal = Calendar.getInstance();
                                    cal.set(11, 0);
                                    cal.set(12, 0);
                                    cal.set(13, 0);
                                    cal.set(14, 0);
                                    dateParm.setDate(cal.getTime());
                                }
                                dateParms.add(dateParm);
                                continue;
                            }
                            throw new ReportException("Unsupported report parameter type " + reportParm.getValueClassName());
                        }
                        LOG.debug("SKIPPING {}", (Object)reportParm.getName());
                    }
                    return reportParameters;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ReportException) {
                throw (ReportException)((Object)e);
            }
            throw new ReportException((Throwable)e);
        }
    }

    public void render(final String reportId, final String location, final ReportFormat format, final OutputStream outputStream) throws ReportException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        JasperPrint jasperPrint = JasperReportService.this.getJasperPrint(location);
                        switch (format) {
                            case PDF: {
                                LOG.debug("rendering as PDF");
                                JasperReportService.this.exportReportToPdf(jasperPrint, outputStream);
                                break;
                            }
                            case CSV: {
                                LOG.debug("rendering as CSV");
                                JasperReportService.this.exportReportToCsv(jasperPrint, outputStream);
                                break;
                            }
                            default: {
                                LOG.debug("rendering as PDF as no valid format found");
                                JasperReportService.this.exportReportToPdf(jasperPrint, outputStream);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Unable to render report {}", (Object)reportId, (Object)e);
                        throw new ReportException("Unable to render report " + reportId, (Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ReportException) {
                throw (ReportException)((Object)e);
            }
            throw new ReportException((Throwable)e);
        }
    }

    private JasperPrint getJasperPrint(String location) throws JRException {
        if (location.contains("jrpxml")) {
            return JRPrintXmlLoader.load((String)location);
        }
        return (JasperPrint)JRLoader.loadObject((File)new File(location));
    }

    public String run(final Map<String, Object> reportParms, final String reportId) throws ReportException {
        try {
            return (String)Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws Exception {
                    String outputFileName;
                    block8: {
                        String baseDir = System.getProperty("opennms.report.dir");
                        JasperReport jasperReport = JasperReportService.this.getJasperReport(reportId);
                        Map<String, Object> jrReportParms = JasperReportService.this.buildJRparameters(reportParms, jasperReport.getParameters());
                        jrReportParms.putAll(JasperReportService.this.buildSubreport(reportId, jasperReport));
                        outputFileName = new String(baseDir + "/" + jasperReport.getName() + new SimpleDateFormat("-MMddyyyy-HHmm").format(new java.util.Date()) + ".jrprint");
                        LOG.debug("jrprint output file: {}", (Object)outputFileName);
                        try {
                            if ("jdbc".equalsIgnoreCase(JasperReportService.this.m_globalReportRepository.getEngine(reportId))) {
                                DBUtils db = new DBUtils();
                                try {
                                    Connection connection = DataSourceFactory.getInstance().getConnection();
                                    db.watch((Object)connection);
                                    JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)outputFileName, jrReportParms, (Connection)connection);
                                    break block8;
                                }
                                finally {
                                    db.cleanUp();
                                }
                            }
                            if (JasperReportService.this.m_globalReportRepository.getEngine(reportId).equals("null")) {
                                JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)outputFileName, jrReportParms, (JRDataSource)new JREmptyDataSource());
                                break block8;
                            }
                            throw new ReportException("No suitable datasource configured for report " + reportId);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to run report " + reportId, (Throwable)e);
                            if (e instanceof ReportException) {
                                throw (ReportException)e;
                            }
                            throw new ReportException((Throwable)e);
                        }
                    }
                    return outputFileName;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ReportException) {
                throw (ReportException)((Object)e);
            }
            throw new ReportException("Failed to run Jasper report " + reportId, (Throwable)e);
        }
    }

    private Map<String, Object> buildSubreport(String mainReportId, JasperReport mainReport) throws ReportException {
        int idx = mainReportId.indexOf(95);
        String repositoryId = idx > -1 ? mainReportId.substring(0, idx) : "local";
        HashMap<String, Object> subreportMap = new HashMap<String, Object>();
        for (JRParameter parameter : mainReport.getParameters()) {
            if (!"net.sf.jasperreports.engine.JasperReport".equals(parameter.getValueClassName()) || "JASPER_REPORT".equals(parameter.getName())) continue;
            subreportMap.put(parameter.getName(), parameter.getValueClassName());
        }
        for (Map.Entry entry : subreportMap.entrySet()) {
            String reportId = repositoryId + "_" + (String)entry.getKey();
            entry.setValue(this.getJasperReport(reportId));
        }
        for (Map.Entry entry : subreportMap.entrySet()) {
            LOG.debug("Key: {} - Value: {}", entry.getKey(), entry.getValue());
        }
        return subreportMap;
    }

    public void runAndRender(final Map<String, Object> reportParms, final String reportId, final ReportFormat format, final OutputStream outputStream) throws ReportException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    JasperReport jasperReport = JasperReportService.this.getJasperReport(reportId);
                    Map<String, Object> jrReportParms = JasperReportService.this.buildJRparameters(reportParms, jasperReport.getParameters());
                    jrReportParms.putAll(JasperReportService.this.buildSubreport(reportId, jasperReport));
                    if ("jdbc".equalsIgnoreCase(JasperReportService.this.m_globalReportRepository.getEngine(reportId))) {
                        DBUtils db = new DBUtils();
                        try {
                            Connection connection = DataSourceFactory.getInstance().getConnection();
                            db.watch((Object)connection);
                            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, jrReportParms, (Connection)connection);
                            JasperReportService.this.exportReport(format, jasperPrint, outputStream);
                        }
                        finally {
                            db.cleanUp();
                        }
                    } else if ("null".equalsIgnoreCase(JasperReportService.this.m_globalReportRepository.getEngine(reportId))) {
                        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, jrReportParms, (JRDataSource)new JREmptyDataSource());
                        JasperReportService.this.exportReport(format, jasperPrint, outputStream);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ReportException) {
                throw (ReportException)((Object)e);
            }
            throw new ReportException("Failed to run Jasper report " + reportId, (Throwable)e);
        }
    }

    private void exportReport(ReportFormat format, JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        switch (format) {
            case PDF: {
                this.exportReportToPdf(jasperPrint, outputStream);
                break;
            }
            case CSV: {
                this.exportReportToCsv(jasperPrint, outputStream);
                break;
            }
        }
    }

    private void exportReportToPdf(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
    }

    private void exportReportToCsv(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
        exporter.exportReport();
    }

    private Map<String, Object> buildJRparameters(Map<String, Object> onmsReportParms, JRParameter[] reportParms) throws ReportException {
        HashMap<String, Object> jrReportParms = new HashMap<String, Object>();
        for (JRParameter reportParm : reportParms) {
            java.util.Date date;
            if (!this.apply(this.getParameterFilters(), reportParm)) continue;
            String parmName = reportParm.getName();
            if (!onmsReportParms.containsKey(parmName)) {
                throw new ReportException("Required parameter " + parmName + " not supplied to JasperReports by OpenNMS");
            }
            if (reportParm.getValueClassName().equals("java.lang.String")) {
                jrReportParms.put(parmName, (String)onmsReportParms.get(parmName));
                continue;
            }
            if (reportParm.getValueClassName().equals("java.lang.Integer")) {
                jrReportParms.put(parmName, (Integer)onmsReportParms.get(parmName));
                continue;
            }
            if (reportParm.getValueClassName().equals("java.lang.Float")) {
                jrReportParms.put(parmName, (Float)onmsReportParms.get(parmName));
                continue;
            }
            if (reportParm.getValueClassName().equals("java.lang.Double")) {
                jrReportParms.put(parmName, (Double)onmsReportParms.get(parmName));
                continue;
            }
            if (reportParm.getValueClassName().equals("java.util.Date")) {
                jrReportParms.put(parmName, (java.util.Date)onmsReportParms.get(parmName));
                continue;
            }
            if (reportParm.getValueClassName().equals("java.sql.Date")) {
                date = (java.util.Date)onmsReportParms.get(parmName);
                jrReportParms.put(parmName, new Date(date.getTime()));
                continue;
            }
            if (reportParm.getValueClassName().equals("java.sql.Timestamp")) {
                date = (java.util.Date)onmsReportParms.get(parmName);
                jrReportParms.put(parmName, new Timestamp(date.getTime()));
                continue;
            }
            if (reportParm.getValueClassName().equals("java.time.ZoneId")) {
                ZoneId zoneId = ZoneId.of((String)onmsReportParms.get(parmName));
                jrReportParms.put(parmName, zoneId);
                continue;
            }
            throw new ReportException("Unsupported report parameter type " + reportParm.getValueClassName());
        }
        return jrReportParms;
    }

    public void setGlobalReportRepository(GlobalReportRepository globalReportRepository) {
        this.m_globalReportRepository = globalReportRepository;
    }

    private JasperDesign getJasperDesign(String reportId) throws ReportException {
        try {
            JasperDesign jasperDesign = JRXmlLoader.load((InputStream)this.m_globalReportRepository.getTemplateStream(reportId));
            return jasperDesign;
        }
        catch (JRException e) {
            LOG.error("Unable to load report with id '{}'", (Object)reportId, (Object)e);
            throw new ReportException("Unable to load report with id '" + reportId + "'", (Throwable)e);
        }
    }

    private JasperReport getJasperReport(String reportId) throws ReportException {
        JasperDesign jasperDesign = this.getJasperDesign(reportId);
        return this.compileReport(jasperDesign);
    }

    private JasperReport compileReport(JasperDesign jasperDesign) throws ReportException {
        try {
            JasperReport report;
            if ("java".equals(jasperDesign.getLanguage())) {
                SimpleJasperReportsContext reportsContext = new SimpleJasperReportsContext();
                JRPropertiesUtil.getInstance((JasperReportsContext)reportsContext).setProperty("net.sf.jasperreports.compiler.java", CustomJRJdtCompiler.class.getCanonicalName());
                JasperCompileManager jasperCompilerManager = JasperCompileManager.getInstance((JasperReportsContext)reportsContext);
                report = jasperCompilerManager.compile(jasperDesign);
            } else {
                report = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            }
            for (Object eachKey : System.getProperties().keySet()) {
                String eachStringKey = (String)eachKey;
                if (!eachStringKey.startsWith("net.sf.jasperreports")) continue;
                report.setProperty(eachStringKey, System.getProperty(eachStringKey));
            }
            this.compileSubreportsRecursively(report);
            return report;
        }
        catch (JRException e) {
            LOG.error("unable to compile jasper report {}", (Throwable)e);
            throw new ReportException("unable to compile jasperReport", (Throwable)e);
        }
    }

    private void compileSubreportsRecursively(final JasperReport report) {
        JRElementsVisitor.visitReport((JRReport)report, (JRVisitor)new JRVisitorSupport(){

            public void visitSubreport(JRSubreport subreport) {
                String compiledSubreportName = JasperReportService.evaluateToString(report, subreport.getExpression());
                if (compiledSubreportName == null) {
                    LOG.debug("Unable to determine sebreport name: {}, {}", (Object)(report == null ? null : report.getName()), (Object)subreport.getExpression());
                    return;
                }
                String sourceSubreportName = compiledSubreportName.replace(".jasper", ".jrxml");
                File compiledSubreportFile = new File(compiledSubreportName);
                File sourceSubreportFile = new File(sourceSubreportName);
                if (!compiledSubreportFile.exists() || compiledSubreportFile.lastModified() < sourceSubreportFile.lastModified()) {
                    LOG.debug("Compiling Subreport '{}' ...", (Object)compiledSubreportName);
                    try {
                        JasperDesign subreportDesign = JRXmlLoader.load((String)sourceSubreportName);
                        JasperReport subreportCompiled = JasperReportService.this.compileReport(subreportDesign);
                        JRSaver.saveObject((Object)subreportCompiled, (File)compiledSubreportFile);
                        JasperReportService.this.compileSubreportsRecursively(subreportCompiled);
                    }
                    catch (JRException | ReportException e) {
                        LOG.error("Could not compile Jasper Subreport. Expression: {}, Evaluated Expression: {}", new Object[]{subreport.getExpression(), compiledSubreportName, e});
                    }
                    LOG.debug("Subreport '{}' compiled", (Object)compiledSubreportName);
                } else {
                    try {
                        JasperReportService.this.compileSubreportsRecursively((JasperReport)JRLoader.loadObject((File)compiledSubreportFile));
                    }
                    catch (JRException e) {
                        LOG.error("Could not load compiled Jasper Subreport. Expression: {}, Evaluated Expression: {}", new Object[]{subreport.getExpression(), compiledSubreportName, e});
                    }
                }
            }
        });
    }

    protected boolean apply(List<ParameterFilter> parameterFilters, JRParameter reportParm) {
        LOG.debug("Found report parameter {} (isSystemDefined(){}, isForPrompting()={}", new Object[]{reportParm.getName(), reportParm.isSystemDefined(), reportParm.isForPrompting()});
        for (ParameterFilter eachFilter : parameterFilters) {
            if (eachFilter.apply(reportParm)) continue;
            return false;
        }
        return true;
    }

    protected List<ParameterFilter> getParameterFilters() {
        return this.parameterFilters;
    }

    public static String evaluateToString(JasperReport report, JRExpression expression) {
        Objects.requireNonNull(report);
        Objects.requireNonNull(expression);
        SubreportExpressionVisitor visitor = new SubreportExpressionVisitor(report);
        String string = visitor.visit(expression);
        if (string != null) {
            OnmsJexlEngine engine = new OnmsJexlEngine();
            return (String)engine.createExpression(string).evaluate((JexlContext)new MapContext());
        }
        return null;
    }
}

