/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.info;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import java.util.Map;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.VertexInfoPanelItemProvider;
import org.opennms.features.topology.api.info.item.DefaultInfoPanelItem;
import org.opennms.features.topology.api.info.item.InfoPanelItem;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceVertexAttributesInfoPanelItemProvider
extends VertexInfoPanelItemProvider {
    private BusinessServiceManager businessServiceManager;
    private final TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory;

    public BusinessServiceVertexAttributesInfoPanelItemProvider(TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory) {
        this.transactionAwareBeanProxyFactory = transactionAwareBeanProxyFactory;
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = (BusinessServiceManager)this.transactionAwareBeanProxyFactory.createProxy((Object)businessServiceManager);
    }

    private Component createComponent(VertexRef ref) {
        FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(false);
        formLayout.setMargin(false);
        BusinessService businessService = this.businessServiceManager.getBusinessServiceById(((BusinessServiceVertex)ref).getServiceId());
        for (Map.Entry e : businessService.getAttributes().entrySet()) {
            formLayout.addComponent((Component)UIHelper.createLabel((String)((String)e.getKey()), (String)((String)e.getValue())));
        }
        return formLayout;
    }

    protected boolean contributeTo(VertexRef vertexRef, GraphContainer container) {
        return vertexRef instanceof BusinessServiceVertex && !this.businessServiceManager.getBusinessServiceById(((BusinessServiceVertex)vertexRef).getServiceId()).getAttributes().isEmpty();
    }

    protected InfoPanelItem createInfoPanelItem(VertexRef ref, GraphContainer graphContainer) {
        return new DefaultInfoPanelItem().withOrder(10).withTitle("Business Service Attributes").withComponent(this.createComponent(ref));
    }
}

