/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class ReductionKeyVertex
extends AbstractBusinessServiceVertex {
    public static final int MAX_LABEL_LENGTH = 27;
    private static final Pattern REDUCTION_KEY_LABEL_PATTERN = Pattern.compile("^.*\\/(.+?):.*:(.+)$");
    private final String reductionKey;

    public ReductionKeyVertex(GraphVertex graphVertex) {
        this(graphVertex.getReductionKey(), graphVertex.getLevel());
    }

    public ReductionKeyVertex(String reductionKey, int level) {
        super((Object)((Object)AbstractBusinessServiceVertex.Type.ReductionKey) + ":" + reductionKey, ReductionKeyVertex.getLabelFromReductionKey(reductionKey), level);
        this.reductionKey = reductionKey;
        this.setTooltipText(String.format("Reduction Key '%s'", reductionKey));
        this.setIconKey("bsm.reduction-key");
    }

    protected static String getLabelFromReductionKey(String reductionKey) {
        Matcher m = REDUCTION_KEY_LABEL_PATTERN.matcher(reductionKey);
        String label = m.matches() ? String.format("%s:%s", m.group(1), m.group(2)) : reductionKey;
        if (label.length() > 27) {
            return label.substring(0, 27 - "...".length()) + "...";
        }
        return label;
    }

    public String getReductionKey() {
        return this.reductionKey;
    }

    @Override
    public AbstractBusinessServiceVertex.Type getType() {
        return AbstractBusinessServiceVertex.Type.ReductionKey;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Set<String> getReductionKeys() {
        return Sets.newHashSet((Object[])new String[]{this.getReductionKey()});
    }

    @Override
    public <T> T accept(BusinessServiceVertexVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

