/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleGraph;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServicesHideLeafsCriteria;

public class BusinessServiceGraph
extends SimpleGraph {
    public BusinessServiceGraph() {
        super("bsm");
    }

    public Vertex getVertex(VertexRef reference, Criteria ... criteria) {
        Vertex theVertex = super.getVertex(reference, criteria);
        return this.filter(theVertex, criteria);
    }

    public Vertex getVertex(String namespace, String id) {
        if (!this.isValidVertexId(id)) {
            id = (Object)((Object)AbstractBusinessServiceVertex.Type.BusinessService) + ":" + id;
        }
        return super.getVertex(namespace, id);
    }

    public List<Vertex> getVertices(Criteria ... criteria) {
        List vertices = super.getVertices(criteria);
        List filter = this.filter((VertexRef)vertices, criteria);
        return new ArrayList<Vertex>(filter);
    }

    public List<Vertex> getVertices(Collection<? extends VertexRef> references, Criteria ... criteria) {
        List vertices = super.getVertices(references, criteria);
        List filteredVertices = this.filter((VertexRef)vertices, criteria);
        return new ArrayList<Vertex>(filteredVertices);
    }

    private <T extends VertexRef> Collection<T> filter(List<T> references, Criteria ... criteria) {
        return Collections2.filter(references, input -> this.filter(input, criteria) != null);
    }

    private <T extends VertexRef> T filter(T refToFilter, Criteria ... criteria) {
        if (this.hideLeafElement(Arrays.asList(criteria))) {
            AbstractBusinessServiceVertex vertex = (AbstractBusinessServiceVertex)refToFilter;
            if (vertex.isLeaf() && !(vertex instanceof BusinessServiceVertex)) {
                return null;
            }
            return refToFilter;
        }
        return refToFilter;
    }

    private boolean hideLeafElement(List<Criteria> criteria) {
        return criteria.stream().filter(e -> e instanceof BusinessServicesHideLeafsCriteria).findFirst().isPresent();
    }

    private boolean isValidVertexId(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return false;
        }
        for (AbstractBusinessServiceVertex.Type eachType : AbstractBusinessServiceVertex.Type.values()) {
            if (!id.startsWith(eachType.name())) continue;
            return true;
        }
        return false;
    }
}

