/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class BridgeForwardingTableEntry
implements Topology {
    private Integer m_node;
    private Integer m_bridgePort;
    private Integer m_bridgePortIfIndex;
    private String m_macAddress;
    private Integer m_vlan;
    private BridgeDot1qTpFdbStatus m_status;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BridgeForwardingTableEntry that = (BridgeForwardingTableEntry)o;
        return Objects.equals(this.m_node, that.m_node) && Objects.equals(this.m_bridgePort, that.m_bridgePort) && Objects.equals(this.m_macAddress, that.m_macAddress);
    }

    public int hashCode() {
        return Objects.hash(this.m_node, this.m_bridgePort, this.m_macAddress);
    }

    public Integer getNodeId() {
        return this.m_node;
    }

    public void setNodeId(Integer node) {
        this.m_node = node;
    }

    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    public Integer getBridgePortIfIndex() {
        return this.m_bridgePortIfIndex;
    }

    public void setBridgePortIfIndex(Integer bridgePortIfIndex) {
        this.m_bridgePortIfIndex = bridgePortIfIndex;
    }

    public String getMacAddress() {
        return this.m_macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.m_macAddress = macAddress;
    }

    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    public BridgeDot1qTpFdbStatus getBridgeDot1qTpFdbStatus() {
        return this.m_status;
    }

    public void setBridgeDot1qTpFdbStatus(BridgeDot1qTpFdbStatus status) {
        this.m_status = status;
    }

    @Override
    public String printTopology() {
        StringBuilder strbfr = new StringBuilder();
        strbfr.append("[");
        strbfr.append(this.getMacAddress());
        strbfr.append(", bridge:[");
        strbfr.append(this.getNodeId());
        strbfr.append("], bridgeport:");
        strbfr.append(this.getBridgePort());
        strbfr.append(", ifindex:");
        strbfr.append(this.getBridgePortIfIndex());
        strbfr.append(", vlan:");
        strbfr.append(this.getVlan());
        if (this.getBridgeDot1qTpFdbStatus() != null) {
            strbfr.append(", status:");
            strbfr.append(BridgeDot1qTpFdbStatus.getTypeString(this.getBridgeDot1qTpFdbStatus().getValue()));
        }
        strbfr.append("]");
        return strbfr.toString();
    }

    public static enum BridgeDot1qTpFdbStatus {
        DOT1D_TP_FDB_STATUS_OTHER(1),
        DOT1D_TP_FDB_STATUS_INVALID(2),
        DOT1D_TP_FDB_STATUS_LEARNED(3),
        DOT1D_TP_FDB_STATUS_SELF(4),
        DOT1D_TP_FDB_STATUS_MGMT(5);

        private final int m_type;
        static final Map<Integer, String> s_typeMap;

        private BridgeDot1qTpFdbStatus(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return "other-vendor-specific";
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static BridgeDot1qTpFdbStatus get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from null code");
            }
            if (code <= 0) {
                throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from" + code + " code");
            }
            switch (code) {
                case 1: {
                    return DOT1D_TP_FDB_STATUS_OTHER;
                }
                case 2: {
                    return DOT1D_TP_FDB_STATUS_INVALID;
                }
                case 3: {
                    return DOT1D_TP_FDB_STATUS_LEARNED;
                }
                case 4: {
                    return DOT1D_TP_FDB_STATUS_SELF;
                }
                case 5: {
                    return DOT1D_TP_FDB_STATUS_MGMT;
                }
            }
            throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "other");
            s_typeMap.put(2, "invalid");
            s_typeMap.put(3, "learned");
            s_typeMap.put(4, "self");
            s_typeMap.put(5, "mgmt");
        }
    }
}

