/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.bootstrap;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class OpenNMSProxyLoginModule
implements LoginModule {
    private static volatile ClassLoader m_classLoader;
    private LoginModule m_delegate;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (m_classLoader == null) {
            System.err.println("WARNING: OpenNMSProxyLoginModule is being initialized, but no classloader is set from bootstrap!");
        }
        ClassLoader cl = m_classLoader == null ? Thread.currentThread().getContextClassLoader() : m_classLoader;
        try {
            Class<?> clazz = cl.loadClass("org.opennms.web.springframework.security.OpenNMSLoginModule");
            this.m_delegate = (LoginModule)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        if (this.m_delegate == null) {
            throw new RuntimeException("OpenNMSLoginModule could not be loaded!");
        }
        this.m_delegate.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        return this.m_delegate == null ? false : this.m_delegate.login();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.m_delegate == null ? false : this.m_delegate.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.m_delegate == null ? false : this.m_delegate.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.m_delegate == null ? false : this.m_delegate.logout();
    }

    public static void setClassloader(ClassLoader cl) {
        m_classLoader = cl;
    }
}

