/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.internal.JAXRSConnector;
import java.util.Dictionary;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class Configuration
implements ManagedService {
    static final String CONFIG_SERVICE_PID = "com.eclipsesource.jaxrs.connector";
    static final String PROPERTY_ROOT = "root";
    static final String PROPERTY_PUBLISH_DELAY = "publishDelay";
    static final long DEFAULT_PUBLISH_DELAY = 150L;
    private final JAXRSConnector connector;
    private long publishDelay;
    private String defaultRootPath;

    public Configuration(JAXRSConnector jaxRsConnector) {
        this.connector = jaxRsConnector;
        this.publishDelay = 150L;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null) {
            Object root = properties.get(PROPERTY_ROOT);
            this.ensureRootIsPresent(root);
            String rootPath = (String)root;
            this.ensureRootIsValid(rootPath);
            this.defaultRootPath = rootPath;
            this.publishDelay = this.getPublishDelay(properties);
            this.connector.updateConfiguration(this);
        }
    }

    private void ensureRootIsValid(String rootPath) throws ConfigurationException {
        if (!rootPath.startsWith("/")) {
            throw new ConfigurationException(PROPERTY_ROOT, "Root path does not start with a /");
        }
    }

    private void ensureRootIsPresent(Object root) throws ConfigurationException {
        if (root == null || !(root instanceof String)) {
            throw new ConfigurationException(PROPERTY_ROOT, "Property is not set or invalid.");
        }
    }

    private long getPublishDelay(Dictionary properties) {
        Object interval = properties.get(PROPERTY_PUBLISH_DELAY);
        if (interval == null) {
            return 150L;
        }
        return (Long)interval;
    }

    public long getPublishDelay() {
        return this.publishDelay;
    }

    public String getDefaultRootPath() {
        return this.defaultRootPath == null ? "/services" : this.defaultRootPath;
    }
}

