/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.opennms.netmgt.flows.classification.IpAddr;

public class IpRange
implements Iterable<IpAddr> {
    public final IpAddr begin;
    public final IpAddr end;

    public static IpRange of(String addr) {
        IpAddr a = IpAddr.of((String)addr);
        return new IpRange(a, a);
    }

    public static IpRange of(String begin, String end) {
        return new IpRange(IpAddr.of((String)begin), IpAddr.of((String)end));
    }

    public IpRange(IpAddr begin, IpAddr end) {
        if (begin.getClass() != end.getClass()) {
            throw new IllegalArgumentException("IpRange can not mix IPv4 and IPv6 addresses - begin: " + begin.getClass().getSimpleName() + "; end: " + end.getClass().getSimpleName());
        }
        if (begin.compareTo((Object)end) > 0) {
            throw new IllegalArgumentException(String.format("beginning of range (%s) must come before end of range (%s)", begin, end));
        }
        this.begin = begin;
        this.end = end;
    }

    public boolean contains(IpAddr addr) {
        return this.begin.compareTo((Object)addr) <= 0 && addr.compareTo((Object)this.end) <= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpRange ipAddrs = (IpRange)o;
        return this.begin.equals(ipAddrs.begin) && this.end.equals(ipAddrs.end);
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.begin).append(',').append(this.end).append(']');
        return buf.toString();
    }

    @Override
    public Iterator<IpAddr> iterator() {
        return new Iterator<IpAddr>(){
            private IpAddr next;
            {
                this.next = IpRange.this.begin;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public IpAddr next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                IpAddr n = this.next;
                this.next = this.next.equals(IpRange.this.end) ? null : this.next.inc();
                return n;
            }
        };
    }
}

