/*
 * Decompiled with CFR 0.152.
 */
package io.hawt;

import io.hawt.jmx.About;
import io.hawt.jmx.JMXSecurity;
import io.hawt.jmx.JmxTreeWatcher;
import io.hawt.jmx.PluginRegistry;
import io.hawt.jmx.QuartzFacade;
import io.hawt.jmx.RBACRegistry;
import io.hawt.system.ConfigManager;
import java.util.Objects;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HawtioContextListener.class);
    private final About about;
    private final JmxTreeWatcher treeWatcher;
    private final PluginRegistry registry;
    private final ConfigManager configManager;
    private final JMXSecurity jmxSecurity;
    private final RBACRegistry rbacRegistry;
    private final QuartzFacade quartzFacade;

    public HawtioContextListener() {
        this(new ConfigManager());
    }

    public HawtioContextListener(ConfigManager configManager) {
        this.configManager = Objects.requireNonNull(configManager);
        this.about = new About();
        this.treeWatcher = new JmxTreeWatcher();
        this.registry = new PluginRegistry();
        this.jmxSecurity = new JMXSecurity();
        this.rbacRegistry = new RBACRegistry();
        this.quartzFacade = new QuartzFacade();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        LOGGER.info("Initialising hawtio services");
        try {
            this.about.init();
            this.configManager.init(servletContextEvent.getServletContext());
            this.treeWatcher.init();
            this.registry.init();
            this.jmxSecurity.init();
            this.rbacRegistry.init();
            this.quartzFacade.init();
        }
        catch (Exception e) {
            throw this.createServletException(e);
        }
        servletContextEvent.getServletContext().setAttribute("ConfigManager", (Object)this.configManager);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        LOGGER.info("Destroying hawtio services");
        try {
            this.rbacRegistry.destroy();
            this.about.destroy();
            this.treeWatcher.destroy();
            this.registry.destroy();
            this.configManager.destroy();
            this.jmxSecurity.destroy();
            this.quartzFacade.destroy();
        }
        catch (Exception e) {
            throw this.createServletException(e);
        }
    }

    protected RuntimeException createServletException(Exception e) {
        return new RuntimeException(e);
    }
}

