/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.BmpAdapterTools;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.Type;
import org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport;

public abstract class Record {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSSSSS").withZone(ZoneOffset.UTC);
    private final Type type;

    protected Record(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    public static String formatTimestamp(Instant timestamp) {
        if (timestamp == null) {
            return null;
        }
        return TIMESTAMP_FORMATTER.format(timestamp);
    }

    public static String hash(String ... values) {
        Hasher hasher = Hashing.md5().newHasher();
        for (String value : values) {
            hasher.putString((CharSequence)(value != null ? value : ""), StandardCharsets.UTF_8);
        }
        return hasher.hash().toString();
    }

    public static String hash(Transport.IpAddress address, long distinguisher, String routerHashId) {
        return Record.hash(BmpAdapterTools.addressAsStr(address), Long.toString(distinguisher), routerHashId);
    }

    protected abstract String[] fields();

    public final Type getType() {
        return this.type;
    }

    public final void serialize(StringBuffer buffer) {
        Iterator fields = Arrays.stream(this.fields()).map(field -> field != null ? field.replace('\t', ' ').replace('\n', '\r') : "").iterator();
        if (fields.hasNext()) {
            buffer.append((String)fields.next());
            while (fields.hasNext()) {
                buffer.append('\t');
                buffer.append((String)fields.next());
            }
        }
        buffer.append('\n');
    }

    public static String boolAsInt(Boolean truthyFalsy) {
        if (truthyFalsy == null || !truthyFalsy.booleanValue()) {
            return "0";
        }
        return "1";
    }

    public static String nullSafeStr(Long val) {
        if (val == null) {
            return "0";
        }
        return Long.toString(val);
    }

    public static String nullSafeStr(Integer val) {
        if (val == null) {
            return "0";
        }
        return Integer.toString(val);
    }

    public static String nullSafeStr(InetAddress addr) {
        if (addr == null) {
            return "";
        }
        return InetAddressUtils.str((InetAddress)addr);
    }
}

