/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.error;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

public class ExecutionError
implements Serializable {
    private static final long serialVersionUID = 740619427108653407L;
    protected String errorId;
    protected String type;
    protected String deploymentId;
    protected String processInstanceId;
    protected String processId;
    protected Long activityId;
    protected String activityName;
    protected Long jobId;
    protected String errorMessage;
    protected String error;
    protected Short acknowledged = 0;
    protected String acknowledgedBy;
    protected Date acknowledgedAt;
    protected Date errorDate;
    protected Long initActivityId;

    public ExecutionError() {
        this.errorId = UUID.randomUUID().toString();
    }

    public ExecutionError(String errorId, String type, String deploymentId, String processInstanceId, String processId, Long activityId, String activityName, Long jobId, String errorMessage, short acknowledged, String acknowledgedBy, Date acknowledgedAt, Date errorDate) {
        this(errorId, type, deploymentId, processInstanceId, processId, activityId, activityName, jobId, errorMessage, null, acknowledged, acknowledgedBy, acknowledgedAt, errorDate);
    }

    public ExecutionError(String errorId, String type, String deploymentId, String processInstanceId, String processId, Long activityId, String activityName, Long jobId, String errorMessage, String error, short acknowledged, String acknowledgedBy, Date acknowledgedAt, Date errorDate) {
        this.errorId = errorId;
        this.type = type;
        this.deploymentId = deploymentId;
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.activityId = activityId;
        this.activityName = activityName;
        this.jobId = jobId;
        this.errorMessage = errorMessage;
        this.error = error;
        this.acknowledged = acknowledged;
        this.acknowledgedBy = acknowledgedBy;
        this.acknowledgedAt = acknowledgedAt;
        this.errorDate = errorDate;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    protected Short getAcknowledged() {
        return this.acknowledged;
    }

    protected void setAcknowledged(Short acknowledged) {
        this.acknowledged = acknowledged;
    }

    public boolean isAcknowledged() {
        if (this.acknowledged == null) {
            return false;
        }
        return this.acknowledged == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAcknowledged(boolean acknowledged) {
        this.setAcknowledged(acknowledged ? Short.valueOf("1") : Short.valueOf("0"));
    }

    public String getAcknowledgedBy() {
        return this.acknowledgedBy;
    }

    public void setAcknowledgedBy(String acknowledgedBy) {
        this.acknowledgedBy = acknowledgedBy;
    }

    public Date getAcknowledgedAt() {
        return this.acknowledgedAt;
    }

    public void setAcknowledgedAt(Date acknowledgedAt) {
        this.acknowledgedAt = acknowledgedAt;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Date getErrorDate() {
        return this.errorDate;
    }

    public void setErrorDate(Date errorDate) {
        this.errorDate = errorDate;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public Long getInitActivityId() {
        return this.initActivityId;
    }

    public void setInitActivityId(Long initActivityId) {
        this.initActivityId = initActivityId;
    }

    public String toString() {
        return "ExecutionError [type=" + this.type + ", deploymentId=" + this.deploymentId + ", processInstanceId=" + this.processInstanceId + ", processId=" + this.processId + ", activityId=" + this.activityId + ", activityName=" + this.activityName + ", errorMessage=" + this.errorMessage + ", acknowledged=" + this.acknowledged + ", acknowledgedBy=" + this.acknowledgedBy + ", acknowledgedAt=" + this.acknowledgedAt + "]";
    }

    public static class Builder {
        private ExecutionError error = new ExecutionError();

        public ExecutionError build() {
            return this.error;
        }

        public Builder type(String type) {
            this.error.setType(type);
            return this;
        }

        public Builder deploymentId(String deploymentId) {
            this.error.setDeploymentId(deploymentId);
            return this;
        }

        public Builder message(String message) {
            this.error.setErrorMessage(message);
            return this;
        }

        public Builder error(String errorStr) {
            this.error.setError(errorStr);
            return this;
        }

        public Builder acknowledgedBy(String user) {
            this.error.setAcknowledgedBy(user);
            return this;
        }

        public Builder processInstanceId(String piId) {
            this.error.setProcessInstanceId(piId);
            return this;
        }

        public Builder activityId(Long activityId) {
            this.error.setActivityId(activityId);
            return this;
        }

        public Builder acknowledged(boolean acknowledged) {
            this.error.setAcknowledged(acknowledged ? Short.valueOf("1") : Short.valueOf("0"));
            return this;
        }

        public Builder acknowledgedAt(Date acknowledgedAt) {
            this.error.setAcknowledgedAt(acknowledgedAt);
            return this;
        }

        public Builder processId(String processId) {
            this.error.setProcessId(processId);
            return this;
        }

        public Builder activityName(String activityName) {
            this.error.setActivityName(activityName);
            return this;
        }

        public Builder errorDate(Date errorDate) {
            this.error.setErrorDate(errorDate);
            return this;
        }

        public Builder jobId(Long jobId) {
            this.error.setJobId(jobId);
            return this;
        }

        public Builder initActivityId(Long initActivityId) {
            this.error.setInitActivityId(initActivityId);
            return this;
        }
    }
}

