/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UnsignedValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.DataRecord;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Field;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Scope;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;

public final class ScopeFieldSpecifier
implements Field,
Scope {
    public static final String SCOPE_SYSTEM = "SCOPE:SYSTEM";
    public static final String SCOPE_INTERFACE = "SCOPE:INTERFACE";
    public static final String SCOPE_LINE_CARD = "SCOPE:LINE_CARD";
    public static final String SCOPE_CACHE = "SCOPE:CACHE";
    public static final String SCOPE_TEMPLATE = "SCOPE:TEMPLATE";
    public static final int SIZE = 4;
    public final int fieldType;
    public final int fieldLength;
    public final InformationElement field;
    public final InformationElementDatabase informationElementDatabase;

    public ScopeFieldSpecifier(InformationElementDatabase informationElementDatabase, ByteBuf buffer) throws InvalidPacketException {
        this.fieldType = BufferUtils.uint16((ByteBuf)buffer);
        this.fieldLength = BufferUtils.uint16((ByteBuf)buffer);
        this.informationElementDatabase = informationElementDatabase;
        this.field = ScopeFieldSpecifier.from(informationElementDatabase, this.fieldType).orElseThrow(() -> new InvalidPacketException(buffer, "Invalid scope field type: 0x%04X", this.fieldType));
        if (this.fieldLength > this.field.getMaximumFieldLength() || this.fieldLength < this.field.getMinimumFieldLength()) {
            throw new InvalidPacketException(buffer, "Template scope field '%s' has illegal size: %d (min=%d, max=%d)", this.field.getName(), this.fieldLength, this.field.getMinimumFieldLength(), this.field.getMaximumFieldLength());
        }
    }

    @Override
    public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) throws InvalidPacketException, MissingTemplateException {
        try {
            return this.field.parse(this.informationElementDatabase, resolver, buffer);
        }
        catch (InvalidPacketException e) {
            throw new InvalidPacketException(e, "Failed to parse Netflow9 scope field: fieldType=%d", this.fieldType);
        }
    }

    @Override
    public int length() {
        return this.fieldLength;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scopeFieldType", this.fieldType).add("scopeFieldLength", this.fieldLength).toString();
    }

    private static Optional<InformationElement> from(InformationElementDatabase informationElementDatabase, int fieldType) {
        switch (fieldType) {
            case 1: {
                return Optional.of(UnsignedValue.parserWith64Bit(informationElementDatabase, SCOPE_SYSTEM, Optional.empty()));
            }
            case 2: {
                return Optional.of(UnsignedValue.parserWith64Bit(informationElementDatabase, SCOPE_INTERFACE, Optional.empty()));
            }
            case 3: {
                return Optional.of(UnsignedValue.parserWith64Bit(informationElementDatabase, SCOPE_LINE_CARD, Optional.empty()));
            }
            case 4: {
                return Optional.of(UnsignedValue.parserWith64Bit(informationElementDatabase, SCOPE_CACHE, Optional.empty()));
            }
            case 5: {
                return Optional.of(UnsignedValue.parserWith64Bit(informationElementDatabase, SCOPE_TEMPLATE, Optional.empty()));
            }
        }
        return Optional.empty();
    }

    public static List<Value<?>> buildScopeValues(DataRecord record) {
        ImmutableList.Builder values = ImmutableList.builder();
        values.add((Object)new UnsignedValue(SCOPE_SYSTEM, record.set.packet.header.sourceId));
        values.add((Object)new UnsignedValue(SCOPE_TEMPLATE, record.set.template.id));
        return values.build();
    }
}

