/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;

public final class Header {
    public static final int SIZE = 16;
    public static final int VERSION = 10;
    public final int versionNumber;
    public final int length;
    public final long exportTime;
    public final long sequenceNumber;
    public final long observationDomainId;

    public Header(ByteBuf buffer) throws InvalidPacketException {
        this.versionNumber = BufferUtils.uint16((ByteBuf)buffer);
        if (this.versionNumber != 10) {
            throw new InvalidPacketException(buffer, "Invalid version number: 0x%04X", this.versionNumber);
        }
        this.length = BufferUtils.uint16((ByteBuf)buffer);
        if (this.length <= 0) {
            throw new InvalidPacketException(buffer, "Empty packet", new Object[0]);
        }
        this.exportTime = BufferUtils.uint32((ByteBuf)buffer);
        this.sequenceNumber = BufferUtils.uint32((ByteBuf)buffer);
        this.observationDomainId = BufferUtils.uint32((ByteBuf)buffer);
    }

    public int payloadLength() {
        return this.length - 16;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("versionNumber", this.versionNumber).add("length", this.length).add("exportTime", this.exportTime).add("sequenceNumber", this.sequenceNumber).add("observationDomainId", this.observationDomainId).toString();
    }
}

