/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing.enrichment;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.opennms.integration.api.v1.flows.Flow;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.processing.ConversationKeyUtils;

public class EnrichedFlow
implements org.opennms.integration.api.v1.flows.Flow {
    private Instant receivedAt;
    private Instant timestamp;
    private Long bytes;
    private Flow.Direction direction;
    private String dstAddr;
    private String dstAddrHostname;
    private Long dstAs;
    private Integer dstMaskLen;
    private Integer dstPort;
    private Integer engineId;
    private Integer engineType;
    private Instant deltaSwitched;
    private Instant firstSwitched;
    private int flowRecords;
    private long flowSeqNum;
    private Integer inputSnmp;
    private Integer ipProtocolVersion;
    private Instant lastSwitched;
    private String nextHop;
    private String nextHopHostname;
    private Integer outputSnmp;
    private Long packets;
    private Integer protocol;
    private Flow.SamplingAlgorithm samplingAlgorithm;
    private Double samplingInterval;
    private String srcAddr;
    private String srcAddrHostname;
    private Long srcAs;
    private Integer srcMaskLen;
    private Integer srcPort;
    private Integer tcpFlags;
    private Integer tos;
    private Integer dscp;
    private Integer ecn;
    private Flow.NetflowVersion netflowVersion;
    private Integer vlan;
    private String application;
    private String host;
    private String location;
    private Flow.Locality srcLocality;
    private Flow.Locality dstLocality;
    private Flow.Locality flowLocality;
    private Flow.NodeInfo srcNodeInfo;
    private Flow.NodeInfo dstNodeInfo;
    private Flow.NodeInfo exporterNodeInfo;
    private Duration clockCorrection;

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Flow.Locality getSrcLocality() {
        return this.srcLocality;
    }

    public void setSrcLocality(Flow.Locality srcLocality) {
        this.srcLocality = srcLocality;
    }

    public Flow.Locality getDstLocality() {
        return this.dstLocality;
    }

    public void setDstLocality(Flow.Locality dstLocality) {
        this.dstLocality = dstLocality;
    }

    public Flow.Locality getFlowLocality() {
        return this.flowLocality;
    }

    public void setFlowLocality(Flow.Locality flowLocality) {
        this.flowLocality = flowLocality;
    }

    public Flow.NodeInfo getSrcNodeInfo() {
        return this.srcNodeInfo;
    }

    public void setSrcNodeInfo(Flow.NodeInfo srcNodeInfo) {
        this.srcNodeInfo = srcNodeInfo;
    }

    public Flow.NodeInfo getDstNodeInfo() {
        return this.dstNodeInfo;
    }

    public void setDstNodeInfo(Flow.NodeInfo dstNodeInfo) {
        this.dstNodeInfo = dstNodeInfo;
    }

    public Flow.NodeInfo getExporterNodeInfo() {
        return this.exporterNodeInfo;
    }

    public void setExporterNodeInfo(Flow.NodeInfo exporterNodeInfo) {
        this.exporterNodeInfo = exporterNodeInfo;
    }

    public Duration getClockCorrection() {
        return this.clockCorrection;
    }

    public void setClockCorrection(Duration clockCorrection) {
        this.clockCorrection = clockCorrection;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Instant getFirstSwitched() {
        return this.firstSwitched;
    }

    public Instant getDeltaSwitched() {
        return this.deltaSwitched;
    }

    public Instant getLastSwitched() {
        return this.lastSwitched;
    }

    public Instant getReceivedAt() {
        return this.receivedAt;
    }

    public Long getBytes() {
        return this.bytes;
    }

    public Flow.Direction getDirection() {
        return this.direction;
    }

    public String getDstAddr() {
        return this.dstAddr;
    }

    public Optional<String> getDstAddrHostname() {
        return Optional.ofNullable(this.dstAddrHostname);
    }

    public Long getDstAs() {
        return this.dstAs;
    }

    public Integer getDstMaskLen() {
        return this.dstMaskLen;
    }

    public Integer getDstPort() {
        return this.dstPort;
    }

    public Integer getEngineId() {
        return this.engineId;
    }

    public Integer getEngineType() {
        return this.engineType;
    }

    public void setDeltaSwitched(Instant deltaSwitched) {
        this.deltaSwitched = deltaSwitched;
    }

    public void setFirstSwitched(Instant firstSwitched) {
        this.firstSwitched = firstSwitched;
    }

    public int getFlowRecords() {
        return this.flowRecords;
    }

    public long getFlowSeqNum() {
        return this.flowSeqNum;
    }

    public Integer getInputSnmp() {
        return this.inputSnmp;
    }

    public Integer getIpProtocolVersion() {
        return this.ipProtocolVersion;
    }

    public void setLastSwitched(Instant lastSwitched) {
        this.lastSwitched = lastSwitched;
    }

    public String getNextHop() {
        return this.nextHop;
    }

    public Optional<String> getNextHopHostname() {
        return Optional.ofNullable(this.nextHopHostname);
    }

    public Integer getOutputSnmp() {
        return this.outputSnmp;
    }

    public Long getPackets() {
        return this.packets;
    }

    public Integer getProtocol() {
        return this.protocol;
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        return this.samplingAlgorithm;
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public String getSrcAddr() {
        return this.srcAddr;
    }

    public Optional<String> getSrcAddrHostname() {
        return Optional.ofNullable(this.srcAddrHostname);
    }

    public Long getSrcAs() {
        return this.srcAs;
    }

    public Integer getSrcMaskLen() {
        return this.srcMaskLen;
    }

    public Integer getSrcPort() {
        return this.srcPort;
    }

    public Integer getTcpFlags() {
        return this.tcpFlags;
    }

    public Integer getTos() {
        return this.tos;
    }

    public Flow.NetflowVersion getNetflowVersion() {
        return this.netflowVersion;
    }

    public Integer getVlan() {
        return this.vlan;
    }

    public void setReceivedAt(Instant receivedAt) {
        this.receivedAt = receivedAt;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    public void setDirection(Flow.Direction direction) {
        this.direction = direction;
    }

    public void setDstAddr(String dstAddr) {
        this.dstAddr = dstAddr;
    }

    public void setDstAddrHostname(String dstAddrHostname) {
        this.dstAddrHostname = dstAddrHostname;
    }

    public void setDstAs(Long dstAs) {
        this.dstAs = dstAs;
    }

    public void setDstMaskLen(Integer dstMaskLen) {
        this.dstMaskLen = dstMaskLen;
    }

    public void setDstPort(Integer dstPort) {
        this.dstPort = dstPort;
    }

    public void setEngineId(Integer engineId) {
        this.engineId = engineId;
    }

    public void setEngineType(Integer engineType) {
        this.engineType = engineType;
    }

    public void setFlowRecords(int flowRecords) {
        this.flowRecords = flowRecords;
    }

    public void setFlowSeqNum(long flowSeqNum) {
        this.flowSeqNum = flowSeqNum;
    }

    public void setInputSnmp(Integer inputSnmp) {
        this.inputSnmp = inputSnmp;
    }

    public void setIpProtocolVersion(Integer ipProtocolVersion) {
        this.ipProtocolVersion = ipProtocolVersion;
    }

    public void setNextHop(String nextHop) {
        this.nextHop = nextHop;
    }

    public void setNextHopHostname(String nextHopHostname) {
        this.nextHopHostname = nextHopHostname;
    }

    public void setOutputSnmp(Integer outputSnmp) {
        this.outputSnmp = outputSnmp;
    }

    public void setPackets(Long packets) {
        this.packets = packets;
    }

    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    public void setSamplingAlgorithm(Flow.SamplingAlgorithm samplingAlgorithm) {
        this.samplingAlgorithm = samplingAlgorithm;
    }

    public void setSamplingInterval(Double samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    public void setSrcAddr(String srcAddr) {
        this.srcAddr = srcAddr;
    }

    public void setSrcAddrHostname(String srcAddrHostname) {
        this.srcAddrHostname = srcAddrHostname;
    }

    public void setSrcAs(Long srcAs) {
        this.srcAs = srcAs;
    }

    public void setSrcMaskLen(Integer srcMaskLen) {
        this.srcMaskLen = srcMaskLen;
    }

    public void setSrcPort(Integer srcPort) {
        this.srcPort = srcPort;
    }

    public void setTcpFlags(Integer tcpFlags) {
        this.tcpFlags = tcpFlags;
    }

    public void setTos(Integer tos) {
        this.tos = tos;
    }

    public Integer getDscp() {
        return this.dscp;
    }

    public void setDscp(Integer dscp) {
        this.dscp = dscp;
    }

    public Integer getEcn() {
        return this.ecn;
    }

    public void setEcn(Integer ecn) {
        this.ecn = ecn;
    }

    public void setNetflowVersion(Flow.NetflowVersion netflowVersion) {
        this.netflowVersion = netflowVersion;
    }

    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    public String getConvoKey() {
        return ConversationKeyUtils.getConvoKeyAsJsonString(this.getLocation(), this.getProtocol(), this.getSrcAddr(), this.getDstAddr(), this.getApplication());
    }

    public static EnrichedFlow from(Flow flow) {
        EnrichedFlow enriched = new EnrichedFlow();
        enriched.setReceivedAt(flow.getReceivedAt());
        enriched.setTimestamp(flow.getTimestamp());
        enriched.setBytes(flow.getBytes());
        enriched.setDirection(flow.getDirection());
        enriched.setDstAddr(flow.getDstAddr());
        flow.getDstAddrHostname().ifPresent(enriched::setDstAddrHostname);
        enriched.setDstAs(flow.getDstAs());
        enriched.setDstMaskLen(flow.getDstMaskLen());
        enriched.setDstPort(flow.getDstPort());
        enriched.setEngineId(flow.getEngineId());
        enriched.setEngineType(flow.getEngineType());
        enriched.setDeltaSwitched(flow.getDeltaSwitched());
        enriched.setFirstSwitched(flow.getFirstSwitched());
        enriched.setFlowRecords(flow.getFlowRecords());
        enriched.setFlowSeqNum(flow.getFlowSeqNum());
        enriched.setInputSnmp(flow.getInputSnmp());
        enriched.setIpProtocolVersion(flow.getIpProtocolVersion());
        enriched.setLastSwitched(flow.getLastSwitched());
        enriched.setNextHop(flow.getNextHop());
        flow.getNextHopHostname().ifPresent(enriched::setNextHopHostname);
        enriched.setOutputSnmp(flow.getOutputSnmp());
        enriched.setPackets(flow.getPackets());
        enriched.setProtocol(flow.getProtocol());
        enriched.setSamplingAlgorithm(flow.getSamplingAlgorithm());
        enriched.setSamplingInterval(flow.getSamplingInterval());
        enriched.setSrcAddr(flow.getSrcAddr());
        flow.getSrcAddrHostname().ifPresent(enriched::setSrcAddrHostname);
        enriched.setSrcAs(flow.getSrcAs());
        enriched.setSrcMaskLen(flow.getSrcMaskLen());
        enriched.setSrcPort(flow.getSrcPort());
        enriched.setTcpFlags(flow.getTcpFlags());
        enriched.setTos(flow.getTos());
        enriched.setDscp(flow.getDscp());
        enriched.setEcn(flow.getEcn());
        enriched.setNetflowVersion(flow.getNetflowVersion());
        enriched.setVlan(flow.getVlan());
        return enriched;
    }
}

