/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.domain;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.domain.AbstractDomainEdge;
import org.opennms.netmgt.graph.domain.AbstractDomainGraph;
import org.opennms.netmgt.graph.domain.AbstractDomainVertex;

public abstract class AbstractDomainGraphContainer<G extends AbstractDomainGraph<? extends AbstractDomainVertex, ? extends AbstractDomainEdge>>
implements ImmutableGraphContainer<G> {
    private final GenericGraphContainer delegate;

    protected AbstractDomainGraphContainer(GenericGraphContainer delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected abstract G convert(GenericGraph var1);

    public List<G> getGraphs() {
        return this.delegate.getGraphs().stream().map(graph -> this.convert((GenericGraph)graph)).collect(Collectors.toList());
    }

    public G getGraph(String namespace) {
        return (G)((AbstractDomainGraph)this.getGraphs().stream().filter(g -> g.getNamespace().equals(namespace)).findFirst().orElse(null));
    }

    public List<String> getNamespaces() {
        return this.delegate.getNamespaces();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getLabel() {
        return this.delegate.getLabel();
    }

    public GraphInfo getGraphInfo(String namespace) {
        Objects.requireNonNull(namespace);
        return this.delegate.getGraphInfo(namespace);
    }

    public GraphInfo getPrimaryGraphInfo() {
        return this.delegate.getPrimaryGraphInfo();
    }

    public List<GraphInfo> getGraphInfos() {
        return this.delegate.getGraphInfos();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public GenericGraphContainer asGenericGraphContainer() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomainGraphContainer that = (AbstractDomainGraphContainer)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static class AbstractDomainGraphContainerBuilder<T extends AbstractDomainGraphContainerBuilder, G extends AbstractDomainGraph<? extends AbstractDomainVertex, ? extends AbstractDomainEdge>> {
        protected final GenericGraphContainer.GenericGraphContainerBuilder builder = GenericGraphContainer.builder();

        protected AbstractDomainGraphContainerBuilder() {
        }

        public T id(String id) {
            this.builder.id(id);
            return (T)this;
        }

        public T label(String label) {
            this.builder.label(label);
            return (T)this;
        }

        public T description(String description) {
            this.builder.description(description);
            return (T)this;
        }

        public T property(String name, Object value) {
            this.builder.property(name, value);
            return (T)this;
        }

        public T properties(Map<String, Object> properties) {
            this.builder.properties(properties);
            return (T)this;
        }

        public T containerInfo(GraphContainerInfo containerInfo) {
            this.builder.applyContainerInfo(containerInfo);
            return (T)this;
        }

        public T addGraph(G graph) {
            this.builder.addGraph(((AbstractDomainGraph)graph).asGenericGraph());
            return (T)this;
        }
    }
}

