/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.domain;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.domain.AbstractDomainEdge;
import org.opennms.netmgt.graph.domain.AbstractDomainVertex;

public abstract class AbstractDomainGraph<V extends AbstractDomainVertex, E extends AbstractDomainEdge>
implements ImmutableGraph<V, E> {
    private final GenericGraph delegate;

    public AbstractDomainGraph(GenericGraph genericGraph) {
        this.delegate = genericGraph;
    }

    public List<V> getVertices() {
        return this.delegate.getVertices().stream().map(this::convert).collect(Collectors.toList());
    }

    public List<E> getEdges() {
        return this.delegate.getEdges().stream().map(this::convert).collect(Collectors.toList());
    }

    protected abstract ImmutableGraph<V, E> convert(GenericGraph var1);

    protected abstract V convert(GenericVertex var1);

    protected abstract E convert(GenericEdge var1);

    public V getVertex(String id) {
        Objects.requireNonNull(id);
        return (V)((AbstractDomainVertex)Optional.ofNullable(this.delegate.getVertex(id)).map(this::convert).orElse(null));
    }

    public E getEdge(String id) {
        Objects.requireNonNull(id);
        return (E)((AbstractDomainEdge)Optional.ofNullable(this.delegate.getEdge(id)).map(this::convert).orElse(null));
    }

    public List<String> getVertexIds() {
        return this.delegate.getVertexIds();
    }

    public List<String> getEdgeIds() {
        return this.delegate.getEdgeIds();
    }

    public ImmutableGraph<V, E> getView(Collection<V> verticesInFocus, int szl) {
        Objects.requireNonNull(verticesInFocus);
        Collection genericVerticesInFocus = verticesInFocus.stream().map(AbstractDomainVertex::asGenericVertex).collect(Collectors.toList());
        GenericGraph genericGraph = this.delegate.getView(genericVerticesInFocus, szl).asGenericGraph();
        return this.convert(genericGraph);
    }

    public List<V> resolveVertices(NodeRef nodeRef) {
        Objects.requireNonNull(nodeRef);
        return this.delegate.resolveVertices(nodeRef).stream().map(this::convert).collect(Collectors.toList());
    }

    public List<V> resolveVertices(Collection<String> vertexIds) {
        return this.delegate.resolveVertices(vertexIds).stream().map(this::convert).collect(Collectors.toList());
    }

    public V resolveVertex(VertexRef vertexRef) {
        GenericVertex vertex = this.delegate.resolveVertex(vertexRef);
        if (vertex != null) {
            return this.convert(vertex);
        }
        return null;
    }

    public List<E> resolveEdges(Collection<String> edgeIds) {
        return this.delegate.resolveEdges(edgeIds).stream().map(this::convert).collect(Collectors.toList());
    }

    public Collection<V> getNeighbors(V vertex) {
        Objects.requireNonNull(vertex);
        return this.delegate.getNeighbors(((AbstractDomainVertex)vertex).asGenericVertex()).stream().map(this::convert).collect(Collectors.toList());
    }

    public Collection<E> getConnectingEdges(V vertex) {
        Objects.requireNonNull(vertex);
        return this.delegate.getConnectingEdges(((AbstractDomainVertex)vertex).asGenericVertex()).stream().map(this::convert).collect(Collectors.toList());
    }

    public Focus getDefaultFocus() {
        return this.delegate.getDefaultFocus();
    }

    public GenericGraph asGenericGraph() {
        return this.delegate;
    }

    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getLabel() {
        return this.delegate.getLabel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomainGraph that = (AbstractDomainGraph)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate).toString();
    }

    public static class AbstractDomainGraphBuilder<T extends AbstractDomainGraphBuilder, V extends AbstractDomainVertex, E extends AbstractDomainEdge> {
        protected GenericGraph.GenericGraphBuilder delegate = GenericGraph.builder();

        protected AbstractDomainGraphBuilder() {
        }

        public T id(String id) {
            this.delegate.id(id);
            return (T)this;
        }

        public T label(String label) {
            this.delegate.label(label);
            return (T)this;
        }

        public T namespace(String namespace) {
            this.delegate.namespace(namespace);
            return (T)this;
        }

        public T property(String name, String value) {
            this.delegate.property(name, (Object)value);
            return (T)this;
        }

        public T description(String description) {
            this.delegate.description(description);
            return (T)this;
        }

        public T addEdges(Collection<E> edges) {
            Objects.requireNonNull(edges);
            edges.forEach(this::addEdge);
            return (T)this;
        }

        public T addVertices(Collection<V> vertices) {
            Objects.requireNonNull(vertices);
            vertices.forEach(this::addVertex);
            return (T)this;
        }

        public T addVertex(V vertex) {
            Objects.requireNonNull(vertex);
            this.delegate.addVertex(((AbstractDomainVertex)vertex).asGenericVertex());
            return (T)this;
        }

        public T addEdge(E edge) {
            Objects.requireNonNull(edge);
            this.delegate.addEdge(((AbstractDomainEdge)edge).asGenericEdge());
            return (T)this;
        }

        public T removeEdge(E edge) {
            Objects.requireNonNull(edge);
            this.delegate.removeEdge(((AbstractDomainEdge)edge).asGenericEdge());
            return (T)this;
        }

        public T removeVertex(V vertex) {
            Objects.requireNonNull(vertex);
            this.delegate.removeVertex(((AbstractDomainVertex)vertex).asGenericVertex());
            return (T)this;
        }

        public T graphInfo(GraphInfo graphInfo) {
            ((GenericGraph.GenericGraphBuilder)this.delegate.namespace(graphInfo.getNamespace()).label(graphInfo.getLabel())).description(graphInfo.getDescription()).build();
            return (T)this;
        }

        public GenericGraph.GenericGraphBuilder.FocusBuilder focus() {
            return this.delegate.focus();
        }

        public VertexRef getVertexRef(String vertexId) {
            return this.delegate.getVertex(vertexId).getVertexRef();
        }
    }
}

