/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmpinterfacepoller.SnmpPollInterfaceMonitor;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterfaceConfig;
import org.opennms.netmgt.snmpinterfacepoller.pollable.SnmpInterfaceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollableSnmpInterface
implements ReadyRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(PollableSnmpInterface.class);
    private volatile Schedule m_schedule;
    private Map<Integer, OnmsSnmpInterface> m_snmpinterfaces;
    private PollableSnmpInterfaceConfig m_snmppollableconfig;
    private PollableInterface m_parent;
    private String m_name;
    private String m_criteria;
    private Set<SnmpInterfaceStatus> m_upValues;
    private Set<SnmpInterfaceStatus> m_downValues;
    private SnmpAgentConfig m_agentConfig;

    public Collection<OnmsSnmpInterface> getSnmpinterfaces() {
        return this.m_snmpinterfaces.values();
    }

    public void setSnmpinterfaces(List<OnmsSnmpInterface> snmpinterfaces) {
        if (snmpinterfaces == null || snmpinterfaces.isEmpty()) {
            LOG.debug("setting snmpinterfaces: got null, thread instantiated but at moment no interface found");
            return;
        }
        HashMap<Integer, Integer> oldStatuses = new HashMap<Integer, Integer>();
        for (Integer ifIndex : this.m_snmpinterfaces.keySet()) {
            OnmsSnmpInterface iface = this.m_snmpinterfaces.get(ifIndex);
            if (iface == null || iface.getIfOperStatus() == null) continue;
            oldStatuses.put(ifIndex, iface.getIfOperStatus());
        }
        this.m_snmpinterfaces.clear();
        for (OnmsSnmpInterface iface : snmpinterfaces) {
            LOG.debug("setting snmpinterface:", (Object)iface.toString());
            if (iface == null || iface.getIfIndex() == null || iface.getIfIndex() <= 0) continue;
            Integer oldStatus = (Integer)oldStatuses.get(iface.getIfIndex());
            LOG.debug("setting snmpinterface (oldStatus={}):{}", (Object)oldStatus, (Object)iface.toString());
            this.m_snmpinterfaces.put(iface.getIfIndex(), iface);
            if (iface.getIfAdminStatus() == null || !this.m_upValues.contains(iface.getIfAdminStatus()) || iface.getIfOperStatus() == null) continue;
            if (this.m_downValues.contains(iface.getIfOperStatus()) && (oldStatus == null || iface.getIfOperStatus() != oldStatus)) {
                this.sendOperDownEvent(iface);
            }
            if (iface.getIfOperStatus().intValue() == SnmpInterfaceStatus.DOWN.getMibValue()) continue;
            this.sendOperDownishEvent(SnmpInterfaceStatus.statusFromMibValue(iface.getIfOperStatus()), iface);
        }
    }

    public PollableSnmpInterface(PollableInterface parent) {
        this.m_parent = parent;
        this.m_snmpinterfaces = new HashMap<Integer, OnmsSnmpInterface>();
    }

    public Schedule getSchedule() {
        return this.m_schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    public PollableSnmpInterfaceConfig getSnmppollableconfig() {
        return this.m_snmppollableconfig;
    }

    public void setSnmppollableconfig(PollableSnmpInterfaceConfig snmppollableconfig) {
        this.m_snmppollableconfig = snmppollableconfig;
    }

    public PollableInterface getParent() {
        return this.m_parent;
    }

    public PollContext getContext() {
        return this.getParent().getContext();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean isReady() {
        return true;
    }

    public void run() {
        if (this.getParent().polling()) {
            String location = this.getContext().getLocation(this.getParent().getNodeid());
            LOG.info("run: polling SNMP interfaces on package/interface {}/{} on primary address: {} at location {}", new Object[]{this.getParent().getPackageName(), this.getName(), this.getParent().getIpaddress(), location});
            if (this.m_snmpinterfaces == null || this.m_snmpinterfaces.isEmpty()) {
                LOG.debug("No Interface found. Doing nothing");
            } else {
                LOG.debug("{} Interfaces found. Getting Statutes....", (Object)this.m_snmpinterfaces.size());
                SnmpPollInterfaceMonitor pollMonitor = new SnmpPollInterfaceMonitor(this.getContext().getLocationAwareSnmpClient());
                pollMonitor.setLocation(location);
                pollMonitor.setInterval(this.getSnmppollableconfig().getInterval());
                int maxiface = this.getMaxInterfacePerPdu();
                if (maxiface == 0) {
                    maxiface = this.m_snmpinterfaces.size();
                }
                LOG.debug("Max Interface Per Pdu is: {}", (Object)maxiface);
                List<SnmpMinimalPollInterface> mifaces = this.getSnmpMinimalPollInterface();
                int start = 0;
                while (start + maxiface < this.m_snmpinterfaces.size()) {
                    this.doPoll(pollMonitor, mifaces.subList(start, start + maxiface));
                    start += maxiface;
                }
                this.doPoll(pollMonitor, mifaces.subList(start, this.m_snmpinterfaces.size()));
            }
        } else {
            LOG.info("not polling: {}", (Object)this.getParent().getIpaddress());
        }
    }

    private void doPoll(SnmpPollInterfaceMonitor pollMonitor, List<SnmpMinimalPollInterface> mifaces) {
        LOG.info("doPoll: input interfaces number: {}", (Object)mifaces.size());
        mifaces = pollMonitor.poll(this.getAgentConfig(), mifaces);
        boolean refresh = false;
        Date now = this.getDate();
        if (mifaces != null) {
            LOG.info("doPoll: PollerMonitor return interfaces number: {}", (Object)mifaces.size());
            for (SnmpMinimalPollInterface miface : mifaces) {
                LOG.debug("Working on interface with ifindex: {}", (Object)miface.getIfindex());
                LOG.debug("Interface PollStatus is {}", (Object)miface.getStatus().getStatusName());
                if (miface.getStatus().isUp()) {
                    OnmsSnmpInterface iface = this.m_snmpinterfaces.get(miface.getIfindex());
                    LOG.debug("Previous status Admin/Oper: {}/{}", (Object)iface.getIfAdminStatus(), (Object)iface.getIfOperStatus());
                    LOG.debug("Current status Admin/Oper: {}/{}", (Object)miface.getAdminstatus(), (Object)miface.getOperstatus());
                    if (this.m_upValues.contains((Object)miface.getAdminstatus()) && this.m_downValues.contains((Object)miface.getOperstatus()) && !this.m_downValues.contains((Object)SnmpInterfaceStatus.statusFromMibValue(iface.getIfOperStatus()))) {
                        this.sendOperDownEvent(iface);
                        if (miface.getOperstatus() != SnmpInterfaceStatus.DOWN) {
                            this.sendOperDownishEvent(miface.getOperstatus(), iface);
                        }
                        miface.setOperPollStatus(PollStatus.unavailable("ifOperStatus is " + miface.getOperstatus().getLabel()));
                        miface.setAdminPollStatus(PollStatus.available());
                    }
                    if (this.m_upValues.contains((Object)miface.getAdminstatus()) && this.m_upValues.contains((Object)miface.getOperstatus()) && !this.m_upValues.contains((Object)SnmpInterfaceStatus.statusFromMibValue(iface.getIfOperStatus()))) {
                        this.sendOperUpEvent(iface);
                        miface.setOperPollStatus(PollStatus.available());
                        miface.setAdminPollStatus(PollStatus.available());
                    }
                    if (this.m_downValues.contains((Object)miface.getAdminstatus()) && !this.m_downValues.contains((Object)SnmpInterfaceStatus.statusFromMibValue(iface.getIfAdminStatus()))) {
                        this.sendAdminDownEvent(iface);
                        miface.setAdminPollStatus(PollStatus.unavailable("ifAdminStatus is " + miface.getAdminstatus().getLabel()));
                    }
                    if (this.m_upValues.contains((Object)miface.getAdminstatus()) && !this.m_upValues.contains((Object)SnmpInterfaceStatus.statusFromMibValue(iface.getIfAdminStatus()))) {
                        this.sendAdminUpEvent(iface);
                        miface.setAdminPollStatus(PollStatus.available());
                    }
                    iface.setIfAdminStatus(Integer.valueOf(miface.getAdminstatus().getMibValue()));
                    iface.setIfOperStatus(Integer.valueOf(miface.getOperstatus().getMibValue()));
                    iface.setLastSnmpPoll(now);
                    try {
                        this.update(iface);
                    }
                    catch (Throwable e) {
                        LOG.warn("Failing updating Interface {} {}", (Object)iface.getIfName(), (Object)e.getLocalizedMessage());
                        refresh = true;
                    }
                    continue;
                }
                LOG.debug("No {} data available for interface.", (Object)this.getContext().getServiceName());
            }
            if (refresh) {
                this.getParent().getParent().refresh(this.getParent().getNodeid());
            }
        } else {
            LOG.error("the monitor return null object");
        }
    }

    private void update(OnmsSnmpInterface iface) {
        this.getContext().update(iface);
    }

    private void sendInterfaceEvent(String uei, OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent(uei, this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getParent().getNetMask(), this.getDate(), iface));
    }

    private void sendAdminUpEvent(OnmsSnmpInterface iface) {
        this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceAdminUp", iface);
    }

    private void sendAdminDownEvent(OnmsSnmpInterface iface) {
        this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceAdminDown", iface);
    }

    private void sendOperUpEvent(OnmsSnmpInterface iface) {
        this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceOperUp", iface);
    }

    private void sendOperDownEvent(OnmsSnmpInterface iface) {
        this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceOperDown", iface);
    }

    private void sendOperDownishEvent(SnmpInterfaceStatus downishStatus, OnmsSnmpInterface iface) {
        switch (downishStatus) {
            case TESTING: {
                this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceOperTesting", iface);
                break;
            }
            case UNKNOWN: {
                this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceOperUnknown", iface);
                break;
            }
            case DORMANT: {
                this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceOperDormant", iface);
                break;
            }
            case NOT_PRESENT: {
                this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceOperNotPresent", iface);
                break;
            }
            case LOWER_LAYER_DOWN: {
                this.sendInterfaceEvent("uei.opennms.org/nodes/snmp/interfaceOperLowerLayerDown", iface);
            }
        }
    }

    private Date getDate() {
        return new Date();
    }

    private SnmpMinimalPollInterface getMinimalFromOnmsSnmpInterface(OnmsSnmpInterface iface) {
        SnmpInterfaceStatus adminStatus = SnmpInterfaceStatus.UP;
        SnmpInterfaceStatus operStatus = SnmpInterfaceStatus.UP;
        if (iface.getIfAdminStatus() != null) {
            adminStatus = SnmpInterfaceStatus.statusFromMibValue(iface.getIfAdminStatus());
        } else {
            iface.setIfAdminStatus(Integer.valueOf(SnmpInterfaceStatus.INVALID.getMibValue()));
        }
        if (iface.getIfOperStatus() != null) {
            operStatus = SnmpInterfaceStatus.statusFromMibValue(iface.getIfOperStatus());
        } else {
            iface.setIfOperStatus(Integer.valueOf(SnmpInterfaceStatus.INVALID.getMibValue()));
        }
        return new SnmpMinimalPollInterface(iface.getIfIndex(), adminStatus, operStatus);
    }

    private List<SnmpMinimalPollInterface> getSnmpMinimalPollInterface() {
        ArrayList<SnmpMinimalPollInterface> mifaces = new ArrayList<SnmpMinimalPollInterface>();
        for (OnmsSnmpInterface iface : this.getSnmpinterfaces()) {
            mifaces.add(this.getMinimalFromOnmsSnmpInterface(iface));
        }
        return mifaces;
    }

    public void schedule() {
        if (this.m_schedule == null) {
            throw new IllegalStateException("Cannot schedule a service whose schedule is set to null");
        }
        this.m_schedule.schedule();
    }

    protected void delete() {
        this.m_schedule.unschedule();
    }

    public SnmpAgentConfig getAgentConfig() {
        return this.m_agentConfig;
    }

    public void setAgentConfig(SnmpAgentConfig config) {
        this.m_agentConfig = config;
    }

    public String getCriteria() {
        return this.m_criteria;
    }

    public void setCriteria(String m_criteria) {
        this.m_criteria = m_criteria;
    }

    public int getMaxInterfacePerPdu() {
        return this.getAgentConfig().getMaxVarsPerPdu();
    }

    public Set<SnmpInterfaceStatus> getUpValues() {
        return this.m_upValues;
    }

    public void setUpValues(Set<SnmpInterfaceStatus> upValues) {
        this.m_upValues = upValues;
    }

    public Set<SnmpInterfaceStatus> getDownValues() {
        return this.m_downValues;
    }

    public void setDownValues(Set<SnmpInterfaceStatus> downValues) {
        this.m_downValues = downValues;
    }

    public static class SnmpMinimalPollInterface {
        int ifindex;
        SnmpInterfaceStatus adminstatus;
        SnmpInterfaceStatus operstatus;
        PollStatus m_status;
        PollStatus m_operPollStatus;
        PollStatus m_adminPollStatus;

        public SnmpMinimalPollInterface(int ifindex, SnmpInterfaceStatus adminstatus, SnmpInterfaceStatus operstatus) {
            this.ifindex = ifindex;
            this.adminstatus = adminstatus;
            this.operstatus = operstatus;
            this.m_status = PollStatus.unknown();
        }

        public int getIfindex() {
            return this.ifindex;
        }

        public void setIfindex(int ifindex) {
            this.ifindex = ifindex;
        }

        public SnmpInterfaceStatus getAdminstatus() {
            return this.adminstatus;
        }

        public void setAdminstatus(SnmpInterfaceStatus adminstatus) {
            this.adminstatus = adminstatus.getMibValue() > 3 ? SnmpInterfaceStatus.INVALID : adminstatus;
        }

        public SnmpInterfaceStatus getOperstatus() {
            return this.operstatus;
        }

        public void setOperstatus(SnmpInterfaceStatus operstatus) {
            this.operstatus = operstatus;
        }

        public PollStatus getStatus() {
            return this.m_status;
        }

        public void setStatus(PollStatus status) {
            this.m_status = status;
        }

        public PollStatus getOperPollStatus() {
            return this.m_operPollStatus;
        }

        public void setOperPollStatus(PollStatus operPollStatus) {
            this.m_operPollStatus = operPollStatus;
        }

        public PollStatus getAdminPollStatus() {
            return this.m_adminPollStatus;
        }

        public void setAdminPollStatus(PollStatus adminPollStatus) {
            this.m_adminPollStatus = adminPollStatus;
        }
    }
}

