/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleXmlAdapter
extends XmlAdapter<String, Double> {
    private static final Logger LOG = LoggerFactory.getLogger(DoubleXmlAdapter.class);

    public Double unmarshal(String v) throws Exception {
        if (v == null || "".equals(v)) {
            return null;
        }
        if ("NaN".equals(v)) {
            return Double.NaN;
        }
        try {
            return Double.valueOf(v);
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to convert unhandled value '{}' to a Double.  Returning null instead.", (Object)v);
            return null;
        }
    }

    public String marshal(Double v) throws Exception {
        if (v == null) {
            return null;
        }
        return v.toString();
    }
}

