/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.scheduler.PostponeNecessary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPollingEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncPollingEngine.class);
    private static final Executor executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Poller-AsyncPollingEngine-%d").build());
    private final int maxConcurrentCalls;
    private final Bulkhead bulkhead;

    public AsyncPollingEngine(int maxConcurrentCalls) {
        this.maxConcurrentCalls = maxConcurrentCalls;
        BulkheadConfig bulkheadConfig = BulkheadConfig.custom().maxConcurrentCalls(maxConcurrentCalls).maxWaitDuration(Duration.ofMillis(500L)).build();
        this.bulkhead = Bulkhead.of((String)"asyncPollingEngine", (BulkheadConfig)bulkheadConfig);
    }

    public void triggerScheduledPollOnService(PollableService svc) {
        CompletionStage<PollStatus> future;
        try {
            this.bulkhead.acquirePermission();
        }
        catch (BulkheadFullException e) {
            LOG.info("Postponing poll for {}. Too many concurrent polls in progress (max=%d).", (Object)this.maxConcurrentCalls);
            throw new PostponeNecessary("BulkheadFullException postpone poll");
        }
        try {
            future = svc.getPollConfig().asyncPoll();
        }
        catch (Throwable t) {
            this.bulkhead.releasePermission();
            throw new RuntimeException(String.format("Failed to trigger poll asynchronously for svc=%s", svc), t);
        }
        future.whenCompleteAsync((res, ex) -> {
            try {
                if (ex == null) {
                    this.processPollResult(svc, (PollStatus)res);
                } else {
                    this.processPollResult(svc, PollableServiceConfig.errorToPollStatus(svc, ex));
                }
            }
            finally {
                this.bulkhead.releasePermission();
            }
        }, executor);
    }

    private void processPollResult(PollableService svc, PollStatus status) {
        svc.doRunWithPreemptivePollStatus(status);
    }

    public long getNumPollsInFlight() {
        return this.bulkhead.getMetrics().getMaxAllowedConcurrentCalls() - this.bulkhead.getMetrics().getAvailableConcurrentCalls();
    }
}

