/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.notifd.ExecutorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor
implements ExecutorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CommandExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String commandLine, List<Argument> arguments) {
        int returnCode = 0;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandLine);
        StringBuilder streamBuffer = new StringBuilder();
        boolean streamed = false;
        for (Argument curArg : arguments) {
            if (!curArg.isStreamed()) {
                if (curArg.getSubstitution() != null && !curArg.getSubstitution().trim().equals("")) {
                    commandList.add(curArg.getSubstitution());
                }
                if (curArg.getValue() == null || curArg.getValue().trim().equals("")) continue;
                commandList.add(curArg.getValue());
                continue;
            }
            streamed = true;
            LOG.debug("streamed argument found");
            if (curArg.getSubstitution() != null && !curArg.getSubstitution().trim().equals("")) {
                streamBuffer.append(curArg.getSubstitution());
            }
            if (curArg.getValue().trim().equals("")) continue;
            streamBuffer.append(curArg.getValue());
            LOG.debug("Streamed argument value: {}", (Object)curArg.getValue());
        }
        try {
            String[] commandArray = new String[commandList.size()];
            commandArray = commandList.toArray(commandArray);
            if (LOG.isDebugEnabled()) {
                StringBuffer list = new StringBuffer();
                list.append("{ ");
                for (int i = 0; i < commandArray.length; ++i) {
                    if (i != 0) {
                        list.append(", ");
                    }
                    list.append(commandArray[i]);
                }
                list.append(" }");
                LOG.debug(list.toString());
            }
            Process command = Runtime.getRuntime().exec(commandArray);
            if (streamed) {
                BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(command.getOutputStream(), StandardCharsets.UTF_8));
                LOG.debug("Streamed arguments: {}", (Object)streamBuffer);
                processInput.write(streamBuffer.toString());
                processInput.flush();
                processInput.close();
            }
            long timeout = 30000L;
            long start = System.currentTimeMillis();
            Object commandResult = "Command timed out (30 seconds)";
            while (System.currentTimeMillis() - start < timeout) {
                try {
                    returnCode = command.exitValue();
                    commandResult = "Command-line binary completed with return code " + returnCode;
                    break;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    CommandExecutor commandExecutor = this;
                    synchronized (commandExecutor) {
                        this.wait(1000L);
                    }
                }
            }
            LOG.debug((String)commandResult);
        }
        catch (IOException e) {
            LOG.error("Error executing command-line binary: {}", (Object)commandLine, (Object)e);
        }
        catch (InterruptedException e) {
            LOG.error("Error executing command-line binary: {}", (Object)commandLine, (Object)e);
        }
        return returnCode;
    }
}

