/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class SnmpIfData {
    private final int m_nodeId;
    private final boolean m_collectionEnabled;
    private final int m_ifIndex;
    private final int m_ifType;
    private final String m_rrdLabel;
    private final String m_ifAlias;
    private final Map<String, String> m_attributes = new HashMap<String, String>();

    public SnmpIfData(OnmsSnmpInterface snmpIface) {
        this.m_nodeId = SnmpIfData.nullSafeUnbox(snmpIface.getNode().getId(), -1);
        this.m_collectionEnabled = snmpIface.isCollectionEnabled();
        this.m_ifIndex = SnmpIfData.nullSafeUnbox(snmpIface.getIfIndex(), -1);
        this.m_ifType = SnmpIfData.nullSafeUnbox(snmpIface.getIfType(), -1);
        this.m_rrdLabel = snmpIface.computeLabelForRRD();
        this.m_ifAlias = snmpIface.getIfAlias();
        this.m_attributes.put("snmpphysaddr", snmpIface.getPhysAddr());
        this.m_attributes.put("snmpifindex", Integer.toString(this.m_ifIndex));
        this.m_attributes.put("snmpifdescr", snmpIface.getIfDescr());
        this.m_attributes.put("snmpiftype", Integer.toString(this.m_ifType));
        this.m_attributes.put("snmpifname", snmpIface.getIfName());
        this.m_attributes.put("snmpifadminstatus", Integer.toString(SnmpIfData.nullSafeUnbox(snmpIface.getIfAdminStatus(), -1)));
        this.m_attributes.put("snmpifoperstatus", Integer.toString(SnmpIfData.nullSafeUnbox(snmpIface.getIfOperStatus(), -1)));
        this.m_attributes.put("snmpifspeed", Long.toString(SnmpIfData.nullSafeUnbox(snmpIface.getIfSpeed(), -1L)));
        this.m_attributes.put("snmpifalias", this.m_ifAlias);
    }

    protected static int nullSafeUnbox(Integer num, int dflt) {
        return num == null ? dflt : num;
    }

    protected static long nullSafeUnbox(Long num, long dflt) {
        return num == null ? dflt : num;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public boolean isCollectionEnabled() {
        return this.m_collectionEnabled;
    }

    public int getIfIndex() {
        return this.m_ifIndex;
    }

    public int getIfType() {
        return this.m_ifType;
    }

    public String getLabelForRRD() {
        return this.m_rrdLabel;
    }

    public String getIfAlias() {
        return this.m_ifAlias;
    }

    public Map<String, String> getAttributesMap() {
        return this.m_attributes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeId", this.m_nodeId).add("collectionEnabled", this.m_collectionEnabled).add("ifIndex", this.m_ifIndex).add("ifType", this.m_ifType).add("rrdLabel", (Object)this.m_rrdLabel).add("ifAlias", (Object)this.m_ifAlias).add("attributes", this.m_attributes).toString();
    }
}

