/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.collectd.MibPropertyAttributeType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointerLikeIndexPropertyExtender
implements SnmpPropertyExtender {
    private static final Logger LOG = LoggerFactory.getLogger(PointerLikeIndexPropertyExtender.class);
    private static final String SOURCE_TYPE = "source-type";
    private static final String SOURCE_ATTRIBUTE = "source-attribute";
    private static final String TARGET_INDEX_POINTER_COLUMN = "target-index-pointer-column";

    @Override
    public SnmpAttribute getTargetAttribute(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        AttributeGroupType groupType;
        String sourceType = property.getParameterValue(SOURCE_TYPE);
        if (StringUtils.isBlank((String)sourceType)) {
            LOG.warn("Cannot execute the pointer-like-index property extender because: missing parameter {}", (Object)SOURCE_TYPE);
            return null;
        }
        String sourceAttribute = property.getParameterValue(SOURCE_ATTRIBUTE);
        if (StringUtils.isBlank((String)sourceAttribute)) {
            LOG.warn("Cannot execute the pointer-like-index property extender because: missing parameter {}", (Object)SOURCE_ATTRIBUTE);
            return null;
        }
        String targetIndexPointerColumn = property.getParameterValue(TARGET_INDEX_POINTER_COLUMN);
        if (StringUtils.isBlank((String)targetIndexPointerColumn)) {
            LOG.warn("Cannot execute the pointer-like-index property extender because: missing parameter {}", (Object)TARGET_INDEX_POINTER_COLUMN);
            return null;
        }
        String pointerLikeIndexValue = null;
        Optional<CollectionAttribute> pointedToAttribute = null;
        for (AttributeGroup group : targetResource.getGroups()) {
            for (CollectionAttribute attribute : group.getAttributes()) {
                try {
                    if (!targetIndexPointerColumn.equals(attribute.getName())) continue;
                    pointerLikeIndexValue = attribute.getStringValue();
                }
                catch (Exception e) {
                    LOG.error("Error: " + String.valueOf(e), (Throwable)e);
                }
            }
        }
        if (pointerLikeIndexValue == null) {
            LOG.warn("Could not identify pointer-like-index column {} on target resource {}", (Object)targetIndexPointerColumn, (Object)targetResource);
            return null;
        }
        String desiredIndex = pointerLikeIndexValue;
        pointedToAttribute = sourceAttributes.stream().filter(a -> this.matches(sourceType, sourceAttribute, desiredIndex, (CollectionAttribute)a)).findFirst();
        if (pointedToAttribute != null && pointedToAttribute.isPresent() && (groupType = targetResource.getGroupType(property.getGroupName())) != null) {
            MibPropertyAttributeType type = new MibPropertyAttributeType(targetResource.getResourceType(), property, groupType);
            SnmpValue value = SnmpUtils.getValueFactory().getOctetString(pointedToAttribute.get().getStringValue().getBytes());
            return new SnmpAttribute(targetResource, type, value);
        }
        return null;
    }

    private boolean matches(String sourceType, String sourceAlias, String index, CollectionAttribute a) {
        CollectionResource r = a.getResource();
        return a.getName().equals(sourceAlias) && r.getResourceTypeName().equals(sourceType) && r.getInstance().equals(index);
    }
}

