/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.config.datacollection.MibObject;

public class HexStringAttributeType
extends SnmpAttributeType {
    public static boolean supportsType(String rawType) {
        return rawType.toLowerCase().startsWith("hexstring");
    }

    public HexStringAttributeType(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        super(resourceType, collectionName, mibObj, groupType);
    }

    public AttributeType getType() {
        return AttributeType.STRING;
    }

    @Override
    public void storeAttribute(CollectionAttribute attribute, Persister persister) {
        Object attributeToPersist = attribute;
        if (attribute instanceof SnmpAttribute) {
            attributeToPersist = new SnmpAttributeWrapper((SnmpAttribute)attribute);
        }
        persister.persistStringAttribute(attributeToPersist);
    }

    private static class SnmpAttributeWrapper
    extends SnmpAttribute {
        private final SnmpAttribute m_attribute;

        public SnmpAttributeWrapper(SnmpAttribute attribute) {
            super(attribute.getResource(), (SnmpAttributeType)attribute.getAttributeType(), attribute.getValue());
            this.m_attribute = attribute;
        }

        @Override
        public String getStringValue() {
            return this.m_attribute.getValue().toHexString();
        }
    }
}

